/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.Decimal28SparseVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class Decimal28SparseWriterImpl
extends AbstractFieldWriter {
    private final Decimal28SparseVector.Mutator mutator;
    final Decimal28SparseVector vector;

    public Decimal28SparseWriterImpl(Decimal28SparseVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(Decimal28SparseHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimal28SparseHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal28Sparse(int start, DrillBuf buffer, int scale, int precision) {
        this.mutator.setSafe(this.idx(), start, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

