/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.Decimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal28DenseWriter;

public class Decimal28DenseHolderReaderImpl
extends AbstractFieldReader {
    private Decimal28DenseHolder holder;

    public Decimal28DenseHolderReaderImpl(Decimal28DenseHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(Decimal28DenseHolder h2) {
        h2.start = this.holder.start;
        h2.buffer = this.holder.buffer;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
    }

    @Override
    public void read(NullableDecimal28DenseHolder h2) {
        h2.start = this.holder.start;
        h2.buffer = this.holder.buffer;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 3, this.holder.scale, 28, 12);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 3, this.holder.scale, 28, 12);
    }

    @Override
    public void copyAsValue(Decimal28DenseWriter writer) {
        writer.write(this.holder);
    }
}

