/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import oadd.org.apache.drill.exec.expr.holders.DateHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableDateHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.DateVector;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class DateWriterImpl
extends AbstractFieldWriter {
    private final DateVector.Mutator mutator;
    final DateVector vector;

    public DateWriterImpl(DateVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(DateHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDateHolder h2) {
        this.mutator.setSafe(this.idx(), h2);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDate(long value) {
        this.mutator.setSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

