/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.util;

import java.lang.reflect.Modifier;
import oadd.javassist.ClassPool;
import oadd.javassist.CtClass;
import oadd.javassist.CtConstructor;
import oadd.javassist.CtMethod;
import oadd.javassist.CtNewMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaPatcher {
    static final Logger logger = LoggerFactory.getLogger(GuavaPatcher.class);
    private static boolean patched;

    public static synchronized void patch() {
        if (!patched) {
            try {
                GuavaPatcher.patchStopwatch();
                GuavaPatcher.patchCloseables();
                patched = true;
            }
            catch (Throwable e) {
                logger.warn("Unable to patch Guava classes.", e);
            }
        }
    }

    private static void patchStopwatch() throws Exception {
        ClassPool cp = ClassPool.getDefault();
        CtClass cc = cp.get("oadd.com.google.common.base.Stopwatch");
        for (CtConstructor c : cc.getConstructors()) {
            if (Modifier.isStatic(c.getModifiers())) continue;
            c.setModifiers(1);
        }
        CtMethod newmethod = CtNewMethod.make("public long elapsedMillis() { return elapsed(java.util.concurrent.TimeUnit.MILLISECONDS); }", cc);
        cc.addMethod(newmethod);
        cc.toClass();
        logger.info("Google's Stopwatch patched for old HBase Guava version.");
    }

    private static void patchCloseables() throws Exception {
        ClassPool cp = ClassPool.getDefault();
        CtClass cc = cp.get("oadd.com.google.common.io.Closeables");
        CtMethod newmethod = CtNewMethod.make("public static void closeQuietly(java.io.Closeable closeable) { try{closeable.close();}catch(Exception e){} }", cc);
        cc.addMethod(newmethod);
        cc.toClass();
        logger.info("Google's Closeables patched for old HBase Guava version.");
    }
}

