/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.rpc.user.clusterclient;

import java.util.Set;
import oadd.io.netty.buffer.ByteBuf;
import oadd.org.apache.commons.lang3.StringUtils;
import oadd.org.apache.drill.common.exceptions.UserException;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.GeneralRPCProtos;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.proto.UserProtos;
import oadd.org.apache.drill.exec.rpc.ConnectionThrottle;
import oadd.org.apache.drill.exec.rpc.DrillRpcFuture;
import oadd.org.apache.drill.exec.rpc.user.QueryDataBatch;
import oadd.org.apache.drill.exec.rpc.user.UserResultsListener;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillConnectionImpl;
import oadd.org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Predicate;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSessionImpl
implements DrillSession {
    private static final Logger logger = LoggerFactory.getLogger(DrillSessionImpl.class);
    private final UserProtos.SessionHandle sessionHandle;
    private final DrillConnectionImpl connection;
    private final Set<UserBitShared.QueryId> queries = Sets.newConcurrentHashSet();

    DrillSessionImpl(DrillConnectionImpl connection, UserProtos.SessionHandle sessionHandle) {
        this.connection = connection;
        this.sessionHandle = sessionHandle;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.connection.getAllocator();
    }

    @Override
    public void executeStatement(String sql, UserResultsListener resultsListener) {
        Preconditions.checkArgument(StringUtils.isNotBlank(sql), "sql should not be null or blank");
        Preconditions.checkArgument(resultsListener != null, "resultsListener can not be null");
        this.connection.send(this.connection.getResultHandler().getWrappedListener(this.wrapUserResultListener(resultsListener)), UserProtos.RpcType.RUN_QUERY_WITH_SESSION, UserProtos.RunQueryWithSessionHandle.newBuilder().setRunQuery(UserProtos.RunQuery.newBuilder().setType(UserBitShared.QueryType.SQL).setPlan(sql).build()).setSessionHandle(this.sessionHandle).build(), UserBitShared.QueryId.class, new ByteBuf[0]);
    }

    private UserResultsListener wrapUserResultListener(final UserResultsListener resultsListener) {
        return new UserResultsListener(){
            UserBitShared.QueryId queryId;

            @Override
            public void queryIdArrived(UserBitShared.QueryId queryId) {
                Preconditions.checkNotNull(queryId);
                this.queryId = queryId;
                String wasAdded = DrillSessionImpl.this.queries.add(queryId) ? "was" : "was not";
                logger.debug("query {} {} added to known queries", (Object)queryId, (Object)wasAdded);
                resultsListener.queryIdArrived(queryId);
            }

            @Override
            public void submissionFailed(UserException ex) {
                String wasRemoved = this.queryId != null && DrillSessionImpl.this.queries.remove(this.queryId) ? "was" : "was not";
                logger.debug("query {} {} removed from known queries", this.queryId, wasRemoved, ex);
                resultsListener.submissionFailed(ex);
            }

            @Override
            public void dataArrived(QueryDataBatch result, ConnectionThrottle throttle) {
                logger.debug("data arrived for query {}", (Object)this.queryId);
                if (this.queryId == null || DrillSessionImpl.this.queries.contains(this.queryId)) {
                    resultsListener.dataArrived(result, throttle);
                }
            }

            @Override
            public void queryCompleted(UserBitShared.QueryResult.QueryState state) {
                boolean notify = this.queryId == null || DrillSessionImpl.this.queries.remove(this.queryId);
                logger.debug("query {} was completed with state {}, listener {} {} be notified", this.queryId, state, resultsListener, notify ? "will" : "will not");
                if (notify) {
                    resultsListener.queryCompleted(state);
                }
            }
        };
    }

    @Override
    public DrillRpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId queryId) {
        return this.cancelQuery(queryId, false);
    }

    private DrillRpcFuture<GeneralRPCProtos.Ack> cancelQuery(UserBitShared.QueryId queryId, boolean notifyWhenCompleted) {
        Preconditions.checkArgument(queryId != null, "queryId can not be null");
        logger.debug("cancelling query {}", (Object)queryId);
        if (!notifyWhenCompleted && !this.queries.remove(queryId) || notifyWhenCompleted && !this.queries.contains(queryId)) {
            logger.warn("Trying to cancel unknown query {}, query already completed or cancelled?", (Object)queryId);
        }
        return this.connection.send(UserProtos.RpcType.CANCEL_QUERY_WITH_SESSION, UserProtos.CancelQueryWithSessionHandle.newBuilder().setSessionHandle(this.sessionHandle).setQueryId(queryId).build(), GeneralRPCProtos.Ack.class, new ByteBuf[0]);
    }

    public void close(boolean invokedDirectly) {
        if (invokedDirectly) {
            this.connection.sessionClosedDirectly(this.sessionHandle);
        }
        this.connection.getResultHandler().failAndRemoveListeners(new Predicate<UserBitShared.QueryId>(){

            @Override
            public boolean apply(UserBitShared.QueryId input) {
                return DrillSessionImpl.this.queries.contains(input);
            }
        }, UserException.connectionError().message("Session closed.", new Object[0]));
    }

    @Override
    public void close() {
        this.close(true);
    }
}

