/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oadd.com.fasterxml.jackson.annotation.JsonAutoDetect;
import oadd.com.fasterxml.jackson.annotation.JsonCreator;
import oadd.com.fasterxml.jackson.annotation.JsonInclude;
import oadd.com.fasterxml.jackson.annotation.JsonProperty;
import oadd.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.AbstractMapColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.AbstractPropertied;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.MetadataUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleNameSpace;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"columns", "properties"})
public class TupleSchema
extends AbstractPropertied
implements TupleMetadata {
    public static final String TYPE = "tuple_schema";
    private AbstractMapColumnMetadata parentMap;
    private final TupleNameSpace<ColumnMetadata> nameSpace = new TupleNameSpace();

    public TupleSchema() {
    }

    @JsonCreator
    public TupleSchema(@JsonProperty(value="columns") List<AbstractColumnMetadata> columns, @JsonProperty(value="properties") Map<String, String> properties) {
        columns.forEach(this::addColumn);
        this.setProperties(properties);
    }

    public void bind(AbstractMapColumnMetadata parentMap) {
        this.parentMap = parentMap;
    }

    public TupleSchema copy() {
        TupleSchema tuple = new TupleSchema();
        for (ColumnMetadata md : this) {
            tuple.addColumn(md.copy());
        }
        tuple.setProperties(this.properties());
        return tuple;
    }

    @Override
    public ColumnMetadata add(MaterializedField field) {
        ColumnMetadata md = MetadataUtils.fromField(field);
        this.add(md);
        return md;
    }

    public ColumnMetadata addView(MaterializedField field) {
        ColumnMetadata md = MetadataUtils.fromView(field);
        this.add(md);
        return md;
    }

    public void add(ColumnMetadata md) {
        md.bind(this);
        this.nameSpace.add(md.name(), md);
    }

    @Override
    public int addColumn(ColumnMetadata column) {
        this.add(column);
        return this.size() - 1;
    }

    @Override
    public MaterializedField column(String name) {
        ColumnMetadata md = this.metadata(name);
        return md == null ? null : md.schema();
    }

    @Override
    public ColumnMetadata metadata(String name) {
        return this.nameSpace.get(name);
    }

    @Override
    public int index(String name) {
        return this.nameSpace.indexOf(name);
    }

    @Override
    public MaterializedField column(int index) {
        return this.metadata(index).schema();
    }

    @Override
    public ColumnMetadata metadata(int index) {
        return this.nameSpace.get(index);
    }

    @Override
    public AbstractMapColumnMetadata parent() {
        return this.parentMap;
    }

    @Override
    public int size() {
        return this.nameSpace.count();
    }

    @Override
    public boolean isEmpty() {
        return this.nameSpace.count() == 0;
    }

    @Override
    public Iterator<ColumnMetadata> iterator() {
        return this.nameSpace.iterator();
    }

    @Override
    public boolean isEquivalent(TupleMetadata other) {
        TupleSchema otherSchema = (TupleSchema)other;
        if (this.nameSpace.count() != otherSchema.nameSpace.count()) {
            return false;
        }
        for (int i = 0; i < this.nameSpace.count(); ++i) {
            if (this.nameSpace.get(i).isEquivalent(otherSchema.nameSpace.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<MaterializedField> toFieldList() {
        ArrayList<MaterializedField> cols = new ArrayList<MaterializedField>();
        for (ColumnMetadata md : this.nameSpace) {
            cols.add(md.schema());
        }
        return cols;
    }

    @Override
    @JsonProperty(value="columns")
    public List<ColumnMetadata> toMetadataList() {
        return new ArrayList<ColumnMetadata>(this.nameSpace.entries());
    }

    public BatchSchema toBatchSchema(BatchSchema.SelectionVectorMode svMode) {
        return new BatchSchema(svMode, this.toFieldList());
    }

    public static BatchSchema toBatchSchema(TupleMetadata schema) {
        return ((TupleSchema)schema).toBatchSchema(BatchSchema.SelectionVectorMode.NONE);
    }

    @Override
    public String fullName(int index) {
        return this.fullName(this.metadata(index));
    }

    @Override
    public String fullName(ColumnMetadata column) {
        String quotedName = column.name();
        if (quotedName.contains(".")) {
            quotedName = "`" + quotedName + "`";
        }
        if (this.isRoot()) {
            return column.name();
        }
        return this.fullName() + "." + quotedName;
    }

    public String fullName() {
        if (this.isRoot()) {
            return "<root>";
        }
        return this.parentMap.parentTuple().fullName(this.parentMap);
    }

    public boolean isRoot() {
        return this.parentMap == null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("[").append(this.getClass().getSimpleName()).append(" ");
        builder.append(this.nameSpace.entries().stream().map(Object::toString).collect(Collectors.joining(", ")));
        if (this.hasProperties()) {
            if (!this.nameSpace.entries().isEmpty()) {
                builder.append(", ");
            }
            builder.append("properties: ").append(this.properties());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, String> properties() {
        return super.properties();
    }
}

