/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.DictBuilder;
import oadd.org.apache.drill.exec.record.metadata.MapBuilder;
import oadd.org.apache.drill.exec.record.metadata.RepeatedListBuilder;
import oadd.org.apache.drill.exec.record.metadata.SchemaContainer;
import oadd.org.apache.drill.exec.record.metadata.TupleBuilder;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.UnionBuilder;

public class SchemaBuilder
implements SchemaContainer {
    private TupleBuilder tupleBuilder = new TupleBuilder();
    private BatchSchema.SelectionVectorMode svMode = BatchSchema.SelectionVectorMode.NONE;

    public SchemaBuilder() {
    }

    public SchemaBuilder(BatchSchema baseSchema) {
        for (MaterializedField field : baseSchema) {
            this.add(field);
        }
    }

    public static MaterializedField columnSchema(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return MaterializedField.create(name, TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).build());
    }

    @Override
    public void addColumn(ColumnMetadata column) {
        this.tupleBuilder.addColumn(column);
    }

    public SchemaBuilder add(String name, TypeProtos.MajorType type) {
        return this.add(MaterializedField.create(name, type));
    }

    public SchemaBuilder add(MaterializedField col) {
        this.tupleBuilder.add(col);
        return this;
    }

    public SchemaBuilder add(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        this.tupleBuilder.add(name, type, mode);
        return this;
    }

    public SchemaBuilder add(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.add(name, type);
        return this;
    }

    public SchemaBuilder add(String name, TypeProtos.MinorType type, int width) {
        this.tupleBuilder.add(name, type, width);
        return this;
    }

    public SchemaBuilder add(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.REQUIRED, precision, scale);
    }

    public SchemaBuilder addNullable(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.addNullable(name, type);
        return this;
    }

    public SchemaBuilder addNullable(String name, TypeProtos.MinorType type, int width) {
        this.tupleBuilder.addNullable(name, type, width);
        return this;
    }

    public SchemaBuilder addNullable(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.OPTIONAL, precision, scale);
    }

    public SchemaBuilder addArray(String name, TypeProtos.MinorType type) {
        this.tupleBuilder.addArray(name, type);
        return this;
    }

    public SchemaBuilder addArray(String name, TypeProtos.MinorType type, int precision, int scale) {
        return this.addDecimal(name, type, TypeProtos.DataMode.REPEATED, precision, scale);
    }

    public SchemaBuilder addDecimal(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, int precision, int scale) {
        this.tupleBuilder.addDecimal(name, type, mode, precision, scale);
        return this;
    }

    public SchemaBuilder addArray(String name, TypeProtos.MinorType type, int dims) {
        this.tupleBuilder.addArray(name, type, dims);
        return this;
    }

    public MapBuilder addMap(String name) {
        return this.tupleBuilder.addMap(this, name);
    }

    public MapBuilder addMapArray(String name) {
        return this.tupleBuilder.addMapArray(this, name);
    }

    public DictBuilder addDict(String name, TypeProtos.MinorType keyType) {
        return this.tupleBuilder.addDict(this, name).key(keyType);
    }

    public DictBuilder addDict(String name, TypeProtos.MajorType keyType) {
        return this.tupleBuilder.addDict(this, name).key(keyType);
    }

    public DictBuilder addDictArray(String name, TypeProtos.MinorType keyType) {
        return this.tupleBuilder.addDictArray(this, name).key(keyType);
    }

    public DictBuilder addDictArray(String name, TypeProtos.MajorType keyType) {
        return this.tupleBuilder.addDictArray(this, name).key(keyType);
    }

    public UnionBuilder addUnion(String name) {
        return this.tupleBuilder.addUnion(this, name);
    }

    public UnionBuilder addList(String name) {
        return this.tupleBuilder.addList(this, name);
    }

    public RepeatedListBuilder addRepeatedList(String name) {
        return this.tupleBuilder.addRepeatedList(this, name);
    }

    public SchemaBuilder withSVMode(BatchSchema.SelectionVectorMode svMode) {
        this.svMode = svMode;
        return this;
    }

    public BatchSchema build() {
        return this.tupleBuilder.batchSchema(this.svMode);
    }

    public TupleMetadata buildSchema() {
        return this.tupleBuilder.schema();
    }
}

