/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;

public enum ProjectionType {
    UNPROJECTED,
    WILDCARD,
    UNSPECIFIED,
    SCALAR,
    TUPLE,
    ARRAY,
    TUPLE_ARRAY,
    DICT,
    DICT_ARRAY;


    public boolean isTuple() {
        return this == TUPLE || this == TUPLE_ARRAY;
    }

    public boolean isArray() {
        return this == ARRAY || this == TUPLE_ARRAY || this == DICT_ARRAY;
    }

    public boolean isDict() {
        return this == DICT || this == DICT_ARRAY;
    }

    public boolean isMaybeScalar() {
        return this == UNSPECIFIED || this == SCALAR;
    }

    public static ProjectionType typeFor(TypeProtos.MajorType majorType) {
        if (majorType.getMinorType() == TypeProtos.MinorType.MAP) {
            if (majorType.getMode() == TypeProtos.DataMode.REPEATED) {
                return TUPLE_ARRAY;
            }
            return TUPLE;
        }
        if (majorType.getMinorType() == TypeProtos.MinorType.DICT) {
            if (majorType.getMode() == TypeProtos.DataMode.REPEATED) {
                return DICT_ARRAY;
            }
            return DICT;
        }
        if (majorType.getMode() == TypeProtos.DataMode.REPEATED) {
            return ARRAY;
        }
        return SCALAR;
    }

    public boolean isCompatible(ProjectionType other) {
        switch (other) {
            case UNPROJECTED: 
            case UNSPECIFIED: 
            case WILDCARD: {
                return true;
            }
        }
        switch (this) {
            case ARRAY: {
                return other == ARRAY || other == TUPLE_ARRAY || other == DICT || other == DICT_ARRAY;
            }
            case TUPLE_ARRAY: {
                return other == TUPLE_ARRAY || other == DICT_ARRAY;
            }
            case SCALAR: {
                return other == SCALAR;
            }
            case TUPLE: {
                return other == TUPLE || other == TUPLE_ARRAY || other == DICT || other == DICT_ARRAY;
            }
            case DICT: {
                return other == DICT || other == DICT_ARRAY;
            }
            case UNPROJECTED: 
            case UNSPECIFIED: 
            case WILDCARD: {
                return true;
            }
        }
        throw new IllegalStateException(this.toString());
    }
}

