/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record.metadata;

import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.metadata.AbstractColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.exec.record.metadata.TupleSchema;

public abstract class AbstractMapColumnMetadata
extends AbstractColumnMetadata {
    protected TupleMetadata parentTuple;
    protected final TupleSchema schema;

    public AbstractMapColumnMetadata(MaterializedField schema) {
        this(schema, null);
    }

    AbstractMapColumnMetadata(MaterializedField schema, TupleSchema tupleSchema) {
        super(schema);
        this.schema = tupleSchema == null ? new TupleSchema() : tupleSchema;
        this.schema.bind(this);
    }

    public AbstractMapColumnMetadata(AbstractMapColumnMetadata from) {
        super(from);
        this.schema = from.schema.copy();
    }

    public AbstractMapColumnMetadata(String name, TypeProtos.MinorType type, TypeProtos.DataMode mode, TupleSchema schema) {
        super(name, type, mode);
        this.schema = schema == null ? new TupleSchema() : schema;
    }

    @Override
    public void bind(TupleMetadata parentTuple) {
        this.parentTuple = parentTuple;
    }

    @Override
    public ColumnMetadata.StructureType structureType() {
        return ColumnMetadata.StructureType.TUPLE;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.schema;
    }

    @Override
    public int expectedWidth() {
        return 0;
    }

    public TupleMetadata parentTuple() {
        return this.parentTuple;
    }

    @Override
    public MaterializedField schema() {
        MaterializedField field = this.emptySchema();
        this.schema.toFieldList().forEach(field::addChild);
        return field;
    }

    @Override
    public MaterializedField emptySchema() {
        return MaterializedField.create(this.name, TypeProtos.MajorType.newBuilder().setMinorType(this.type).setMode(this.mode).build());
    }

    @Override
    public String typeString() {
        String typeString = this.internalTypeString();
        return this.isArray() ? "ARRAY<" + typeString + ">" : typeString;
    }

    protected abstract String internalTypeString();
}

