/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression.visitors;

import oadd.org.apache.drill.common.expression.AnyValueExpression;
import oadd.org.apache.drill.common.expression.BooleanOperator;
import oadd.org.apache.drill.common.expression.CastExpression;
import oadd.org.apache.drill.common.expression.ConvertExpression;
import oadd.org.apache.drill.common.expression.ErrorCollector;
import oadd.org.apache.drill.common.expression.FunctionCall;
import oadd.org.apache.drill.common.expression.FunctionHolderExpression;
import oadd.org.apache.drill.common.expression.IfExpression;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.NullExpression;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.common.expression.TypedFieldExpr;
import oadd.org.apache.drill.common.expression.TypedNullConstant;
import oadd.org.apache.drill.common.expression.ValueExpressions;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;

final class ConstantChecker
implements ExprVisitor<Boolean, ErrorCollector, RuntimeException> {
    private static final ConstantChecker INSTANCE = new ConstantChecker();

    private ConstantChecker() {
    }

    public static void checkConstants(LogicalExpression e, ErrorCollector errors) {
        e.accept(INSTANCE, errors);
    }

    @Override
    public Boolean visitFunctionCall(FunctionCall call, ErrorCollector errors) {
        throw new UnsupportedOperationException("FunctionCall is not expected here. It should have been converted to FunctionHolderExpression in materialization");
    }

    @Override
    public Boolean visitFunctionHolderExpression(FunctionHolderExpression holder, ErrorCollector errors) {
        boolean allArgsAreConstant = true;
        for (int i = 0; i < holder.args.size(); ++i) {
            boolean thisArgIsConstant = ((LogicalExpression)holder.args.get(i)).accept(this, errors);
            if (thisArgIsConstant) continue;
            allArgsAreConstant = false;
            if (!holder.argConstantOnly(i)) continue;
            errors.addGeneralError(((LogicalExpression)holder.args.get(i)).getPosition(), String.format("Function %s expects constant input for argument number %d", holder.getName(), i));
        }
        return allArgsAreConstant;
    }

    @Override
    public Boolean visitBooleanOperator(BooleanOperator op, ErrorCollector errors) {
        for (LogicalExpression e : op.args) {
            if (e.accept(this, errors).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitIfExpression(IfExpression ifExpr, ErrorCollector errors) {
        IfExpression.IfCondition c = ifExpr.ifCondition;
        if (!c.condition.accept(this, errors).booleanValue() || !c.expression.accept(this, errors).booleanValue()) {
            return false;
        }
        return ifExpr.elseExpression.accept(this, errors);
    }

    @Override
    public Boolean visitSchemaPath(SchemaPath path, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitIntConstant(ValueExpressions.IntExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitFloatConstant(ValueExpressions.FloatExpression fExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitLongConstant(ValueExpressions.LongExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitDateConstant(ValueExpressions.DateExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitTimeConstant(ValueExpressions.TimeExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitTimeStampConstant(ValueExpressions.TimeStampExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitIntervalYearConstant(ValueExpressions.IntervalYearExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitIntervalDayConstant(ValueExpressions.IntervalDayExpression intExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitBooleanConstant(ValueExpressions.BooleanExpression e, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitQuotedStringConstant(ValueExpressions.QuotedString e, ErrorCollector errors) {
        return true;
    }

    @Override
    public Boolean visitUnknown(LogicalExpression e, ErrorCollector errors) {
        return false;
    }

    @Override
    public Boolean visitCastExpression(CastExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitConvertExpression(ConvertExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitAnyValueExpression(AnyValueExpression e, ErrorCollector value) throws RuntimeException {
        return e.getInput().accept(this, value);
    }

    @Override
    public Boolean visitNullConstant(TypedNullConstant e, ErrorCollector value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitNullExpression(NullExpression e, ErrorCollector value) throws RuntimeException {
        return true;
    }

    @Override
    public Boolean visitParameter(ValueExpressions.ParameterExpression e, ErrorCollector value) throws RuntimeException {
        return false;
    }

    @Override
    public Boolean visitTypedFieldExpr(TypedFieldExpr e, ErrorCollector value) throws RuntimeException {
        return false;
    }
}

