/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common.expression;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import oadd.org.apache.drill.common.expression.ExpressionPosition;
import oadd.org.apache.drill.common.expression.LogicalExpression;
import oadd.org.apache.drill.common.expression.LogicalExpressionBase;
import oadd.org.apache.drill.common.expression.visitors.ExprVisitor;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class ValueExpressions {
    public static LogicalExpression getBigInt(long l) {
        return new LongExpression(l);
    }

    public static LogicalExpression getInt(int i) {
        return new IntExpression(i, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getFloat8(double d) {
        return new DoubleExpression(d, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getFloat4(float f) {
        return new FloatExpression(f, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getBit(boolean b) {
        return new BooleanExpression(Boolean.toString(b), ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getChar(String s2, int precision) {
        return new QuotedString(s2, precision, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getDate(GregorianCalendar date) {
        return new DateExpression(date.getTimeInMillis());
    }

    public static LogicalExpression getDate(long milliSecond) {
        return new DateExpression(milliSecond);
    }

    public static LogicalExpression getTime(GregorianCalendar time) {
        int millis = time.get(11) * 60 * 60 * 1000 + time.get(12) * 60 * 1000 + time.get(13) * 1000 + time.get(14);
        return new TimeExpression(millis);
    }

    public static LogicalExpression getTime(int milliSeconds) {
        return new TimeExpression(milliSeconds);
    }

    public static LogicalExpression getTimeStamp(GregorianCalendar date) {
        return new TimeStampExpression(date.getTimeInMillis());
    }

    public static LogicalExpression getTimeStamp(long milliSeconds) {
        return new TimeStampExpression(milliSeconds);
    }

    public static LogicalExpression getIntervalYear(int months) {
        return new IntervalYearExpression(months);
    }

    public static LogicalExpression getIntervalDay(long intervalInMillis) {
        return new IntervalDayExpression(intervalInMillis);
    }

    public static LogicalExpression getVarDecimal(BigDecimal input, int precision, int scale) {
        return new VarDecimalExpression(input, precision, scale, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getNumericExpression(String sign, String s2, ExpressionPosition ep) {
        String numStr = sign == null ? s2 : sign + s2;
        try {
            int a = Integer.parseInt(numStr);
            return new IntExpression(a, ep);
        }
        catch (Exception a) {
            try {
                long l = Long.parseLong(numStr);
                return new LongExpression(l, ep);
            }
            catch (Exception l) {
                try {
                    double d = Double.parseDouble(numStr);
                    return new DoubleExpression(d, ep);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Unable to parse string %s as integer or floating point number.", numStr));
                }
            }
        }
    }

    public static LogicalExpression getParameterExpression(String name, TypeProtos.MajorType type) {
        return new ParameterExpression(name, type, ExpressionPosition.UNKNOWN);
    }

    public static class ParameterExpression
    extends LogicalExpressionBase {
        private final String name;
        private final TypeProtos.MajorType type;

        protected ParameterExpression(String name, TypeProtos.MajorType type, ExpressionPosition pos) {
            super(pos);
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return this.type;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitParameter(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return ImmutableList.of().iterator();
        }
    }

    public static class QuotedString
    extends ValueExpression<String> {
        public static final QuotedString EMPTY_STRING = new QuotedString("", 0, ExpressionPosition.UNKNOWN);
        private final int precision;

        public QuotedString(String value, int precision, ExpressionPosition pos) {
            super(value, pos);
            this.precision = precision;
        }

        public String getString() {
            return (String)this.value;
        }

        @Override
        protected String parseValue(String s2) {
            return s2;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return Types.withPrecision(TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED, this.precision);
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitQuotedStringConstant(this, value);
        }
    }

    public static class IntervalDayExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INTERVALDAY_CONSTANT = Types.required(TypeProtos.MinorType.INTERVALDAY);
        private static final long MILLIS_IN_DAY = 86400000L;
        private int days;
        private int millis;

        public IntervalDayExpression(long intervalInMillis) {
            this((int)(intervalInMillis / 86400000L), (int)(intervalInMillis % 86400000L), ExpressionPosition.UNKNOWN);
        }

        public IntervalDayExpression(int days, int millis, ExpressionPosition pos) {
            super(pos);
            this.days = days;
            this.millis = millis;
        }

        public int getIntervalDay() {
            return this.days;
        }

        public int getIntervalMillis() {
            return this.millis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INTERVALDAY_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntervalDayConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class IntervalYearExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INTERVALYEAR_CONSTANT = Types.required(TypeProtos.MinorType.INTERVALYEAR);
        private int months;

        public IntervalYearExpression(int months) {
            this(months, ExpressionPosition.UNKNOWN);
        }

        public IntervalYearExpression(int months, ExpressionPosition pos) {
            super(pos);
            this.months = months;
        }

        public int getIntervalYear() {
            return this.months;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INTERVALYEAR_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntervalYearConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class TimeStampExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType TIMESTAMP_CONSTANT = Types.required(TypeProtos.MinorType.TIMESTAMP);
        private long timeInMillis;

        public TimeStampExpression(long timeInMillis) {
            this(timeInMillis, ExpressionPosition.UNKNOWN);
        }

        public TimeStampExpression(long timeInMillis, ExpressionPosition pos) {
            super(pos);
            this.timeInMillis = timeInMillis;
        }

        public long getTimeStamp() {
            return this.timeInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TIMESTAMP_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitTimeStampConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class TimeExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType TIME_CONSTANT = Types.required(TypeProtos.MinorType.TIME);
        private int timeInMillis;

        public TimeExpression(int timeInMillis) {
            this(timeInMillis, ExpressionPosition.UNKNOWN);
        }

        public TimeExpression(int timeInMillis, ExpressionPosition pos) {
            super(pos);
            this.timeInMillis = timeInMillis;
        }

        public int getTime() {
            return this.timeInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TIME_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitTimeConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class DateExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType DATE_CONSTANT = Types.required(TypeProtos.MinorType.DATE);
        private long dateInMillis;

        public DateExpression(long l) {
            this(l, ExpressionPosition.UNKNOWN);
        }

        public DateExpression(long dateInMillis, ExpressionPosition pos) {
            super(pos);
            this.dateInMillis = dateInMillis;
        }

        public long getDate() {
            return this.dateInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return DATE_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDateConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class LongExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType LONG_CONSTANT = Types.required(TypeProtos.MinorType.BIGINT);
        private long l;

        public LongExpression(long l) {
            this(l, ExpressionPosition.UNKNOWN);
        }

        public LongExpression(long l, ExpressionPosition pos) {
            super(pos);
            this.l = l;
        }

        public long getLong() {
            return this.l;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return LONG_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitLongConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class DoubleExpression
    extends LogicalExpressionBase {
        private double d;
        private static final TypeProtos.MajorType DOUBLE_CONSTANT = Types.required(TypeProtos.MinorType.FLOAT8);

        public DoubleExpression(double d, ExpressionPosition pos) {
            super(pos);
            this.d = d;
        }

        public double getDouble() {
            return this.d;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return DOUBLE_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDoubleConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class VarDecimalExpression
    extends LogicalExpressionBase {
        private final BigDecimal bigDecimal;
        private final int precision;
        private final int scale;

        public VarDecimalExpression(BigDecimal input, int precision, int scale, ExpressionPosition pos) {
            super(pos);
            this.bigDecimal = input;
            this.precision = precision;
            this.scale = scale;
        }

        public BigDecimal getBigDecimal() {
            return this.bigDecimal;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setScale(this.scale).setPrecision(this.precision).setMode(TypeProtos.DataMode.REQUIRED).build();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitVarDecimalConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class Decimal38Expression
    extends LogicalExpressionBase {
        private BigDecimal bigDecimal;

        public Decimal38Expression(BigDecimal input, ExpressionPosition pos) {
            super(pos);
            this.bigDecimal = input;
        }

        public BigDecimal getBigDecimal() {
            return this.bigDecimal;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL38SPARSE).setScale(this.bigDecimal.scale()).setPrecision(this.bigDecimal.precision()).setMode(TypeProtos.DataMode.REQUIRED).build();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDecimal38Constant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class Decimal28Expression
    extends LogicalExpressionBase {
        private BigDecimal bigDecimal;

        public Decimal28Expression(BigDecimal input, ExpressionPosition pos) {
            super(pos);
            this.bigDecimal = input;
        }

        public BigDecimal getBigDecimal() {
            return this.bigDecimal;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL28SPARSE).setScale(this.bigDecimal.scale()).setPrecision(this.bigDecimal.precision()).setMode(TypeProtos.DataMode.REQUIRED).build();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDecimal28Constant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class Decimal18Expression
    extends LogicalExpressionBase {
        private long decimal;
        private int scale;
        private int precision;

        public Decimal18Expression(BigDecimal input, ExpressionPosition pos) {
            super(pos);
            this.scale = input.scale();
            this.precision = input.precision();
            this.decimal = input.setScale(this.scale, 4).longValue();
        }

        public long getLongFromDecimal() {
            return this.decimal;
        }

        public int getScale() {
            return this.scale;
        }

        public int getPrecision() {
            return this.precision;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL18).setScale(this.scale).setPrecision(this.precision).setMode(TypeProtos.DataMode.REQUIRED).build();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDecimal18Constant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class Decimal9Expression
    extends LogicalExpressionBase {
        private int decimal;
        private int scale;
        private int precision;

        public Decimal9Expression(BigDecimal input, ExpressionPosition pos) {
            super(pos);
            this.scale = input.scale();
            this.precision = input.precision();
            this.decimal = input.setScale(this.scale, 4).intValue();
        }

        public int getIntFromDecimal() {
            return this.decimal;
        }

        public int getScale() {
            return this.scale;
        }

        public int getPrecision() {
            return this.precision;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL9).setScale(this.scale).setPrecision(this.precision).setMode(TypeProtos.DataMode.REQUIRED).build();
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDecimal9Constant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class IntExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INT_CONSTANT = Types.required(TypeProtos.MinorType.INT);
        private int i;

        public IntExpression(int i, ExpressionPosition pos) {
            super(pos);
            this.i = i;
        }

        public int getInt() {
            return this.i;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INT_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class FloatExpression
    extends LogicalExpressionBase {
        private float f;
        private static final TypeProtos.MajorType FLOAT_CONSTANT = Types.required(TypeProtos.MinorType.FLOAT4);

        public FloatExpression(float f, ExpressionPosition pos) {
            super(pos);
            this.f = f;
        }

        public float getFloat() {
            return this.f;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return FLOAT_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitFloatConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class BooleanExpression
    extends ValueExpression<Boolean> {
        public static final BooleanExpression TRUE = new BooleanExpression("true", ExpressionPosition.UNKNOWN);
        public static final BooleanExpression FALSE = new BooleanExpression("false", ExpressionPosition.UNKNOWN);

        public BooleanExpression(String value, ExpressionPosition pos) {
            super(value, pos);
        }

        @Override
        protected Boolean parseValue(String s2) {
            return Boolean.parseBoolean(s2);
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return Types.REQUIRED_BIT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitBooleanConstant(this, value);
        }

        public boolean getBoolean() {
            return (Boolean)this.value;
        }
    }

    protected static abstract class ValueExpression<V>
    extends LogicalExpressionBase {
        public final V value;

        protected ValueExpression(String value, ExpressionPosition pos) {
            super(pos);
            this.value = this.parseValue(value);
        }

        protected abstract V parseValue(String var1);

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Collections.emptyIterator();
        }
    }
}

