/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseables {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCloseables.class);

    public static AutoCloseable all(final Collection<? extends AutoCloseable> autoCloseables) {
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                AutoCloseables.close(autoCloseables);
            }
        };
    }

    public static void close(Throwable t2, AutoCloseable ... autoCloseables) {
        AutoCloseables.close(t2, Arrays.asList(autoCloseables));
    }

    public static void close(Throwable t2, Collection<? extends AutoCloseable> autoCloseables) {
        try {
            AutoCloseables.close(autoCloseables);
        }
        catch (Exception e) {
            t2.addSuppressed(e);
        }
    }

    public static void close(AutoCloseable ... autoCloseables) throws Exception {
        AutoCloseables.close(Arrays.asList(autoCloseables));
    }

    public static void close(Iterable<? extends AutoCloseable> ac) throws Exception {
        Exception topLevelException = null;
        for (AutoCloseable autoCloseable : ac) {
            try {
                if (autoCloseable == null) continue;
                autoCloseable.close();
            }
            catch (Exception e) {
                if (topLevelException == null) {
                    topLevelException = e;
                    continue;
                }
                topLevelException.addSuppressed(e);
            }
        }
        if (topLevelException != null) {
            throw topLevelException;
        }
    }

    public static void closeSilently(AutoCloseable ... closeables) {
        Arrays.stream(closeables).filter(Objects::nonNull).forEach(target -> {
            try {
                target.close();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Exception was thrown while closing auto closeable: %s", target), e);
            }
        });
    }

    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

