/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.math.analysis.integration;

import oadd.org.apache.commons.math.FunctionEvaluationException;
import oadd.org.apache.commons.math.MathRuntimeException;
import oadd.org.apache.commons.math.MaxIterationsExceededException;
import oadd.org.apache.commons.math.analysis.UnivariateRealFunction;
import oadd.org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import oadd.org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;
import oadd.org.apache.commons.math.exception.util.LocalizedFormats;
import oadd.org.apache.commons.math.util.FastMath;

public class SimpsonIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public SimpsonIntegrator(UnivariateRealFunction f) {
        super(f, 64);
    }

    public SimpsonIntegrator() {
        super(64);
    }

    @Deprecated
    public double integrate(double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min2, max);
    }

    public double integrate(UnivariateRealFunction f, double min2, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        this.clearResult();
        this.verifyInterval(min2, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        if (this.minimalIterationCount == 1) {
            double s2 = (4.0 * qtrap.stage(f, min2, max, 1) - qtrap.stage(f, min2, max, 0)) / 3.0;
            this.setResult(s2, 1);
            return this.result;
        }
        double olds = 0.0;
        double oldt = qtrap.stage(f, min2, max, 0);
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double rLimit;
            double delta;
            double t2 = qtrap.stage(f, min2, max, i);
            double s3 = (4.0 * t2 - oldt) / 3.0;
            if (i >= this.minimalIterationCount && ((delta = FastMath.abs(s3 - olds)) <= (rLimit = this.relativeAccuracy * (FastMath.abs(olds) + FastMath.abs(s3)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(s3, i);
                return this.result;
            }
            olds = s3;
            oldt = t2;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 64) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INVALID_ITERATIONS_LIMITS, 0, 64);
        }
    }
}

