/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.commons.configuration;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import oadd.org.apache.commons.configuration.AbstractConfiguration;
import oadd.org.apache.commons.configuration.ConversionException;
import oadd.org.apache.commons.lang.BooleanUtils;
import oadd.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyConverter {
    static final char LIST_ESC_CHAR = '\\';
    static final String LIST_ESCAPE = String.valueOf('\\');
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_RADIX = 16;
    private static final String BIN_PREFIX = "0b";
    private static final int BIN_RADIX = 2;
    private static final Class<?>[] CONSTR_ARGS = new Class[]{String.class};
    private static final String INTERNET_ADDRESS_CLASSNAME = "javax.mail.internet.InternetAddress";

    private PropertyConverter() {
    }

    static Object to(Class<?> cls, Object value, Object[] params) throws ConversionException {
        if (Boolean.class.equals(cls) || Boolean.TYPE.equals(cls)) {
            return PropertyConverter.toBoolean(value);
        }
        if (Number.class.isAssignableFrom(cls) || cls.isPrimitive()) {
            if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                return PropertyConverter.toInteger(value);
            }
            if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                return PropertyConverter.toLong(value);
            }
            if (Byte.class.equals(cls) || Byte.TYPE.equals(cls)) {
                return PropertyConverter.toByte(value);
            }
            if (Short.class.equals(cls) || Short.TYPE.equals(cls)) {
                return PropertyConverter.toShort(value);
            }
            if (Float.class.equals(cls) || Float.TYPE.equals(cls)) {
                return PropertyConverter.toFloat(value);
            }
            if (Double.class.equals(cls) || Double.TYPE.equals(cls)) {
                return PropertyConverter.toDouble(value);
            }
            if (BigInteger.class.equals(cls)) {
                return PropertyConverter.toBigInteger(value);
            }
            if (BigDecimal.class.equals(cls)) {
                return PropertyConverter.toBigDecimal(value);
            }
        } else {
            if (Date.class.equals(cls)) {
                return PropertyConverter.toDate(value, (String)params[0]);
            }
            if (Calendar.class.equals(cls)) {
                return PropertyConverter.toCalendar(value, (String)params[0]);
            }
            if (URL.class.equals(cls)) {
                return PropertyConverter.toURL(value);
            }
            if (Locale.class.equals(cls)) {
                return PropertyConverter.toLocale(value);
            }
            if (PropertyConverter.isEnum(cls)) {
                return PropertyConverter.convertToEnum(cls, value);
            }
            if (Color.class.equals(cls)) {
                return PropertyConverter.toColor(value);
            }
            if (cls.getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
                return PropertyConverter.toInternetAddress(value);
            }
            if (InetAddress.class.isAssignableFrom(cls)) {
                return PropertyConverter.toInetAddress(value);
            }
        }
        throw new ConversionException("The value '" + value + "' (" + value.getClass() + ")" + " can't be converted to a " + cls.getName() + " object");
    }

    public static Boolean toBoolean(Object value) throws ConversionException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = BooleanUtils.toBooleanObject((String)value);
            if (b == null) {
                throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
            }
            return b;
        }
        throw new ConversionException("The value " + value + " can't be converted to a Boolean object");
    }

    public static Byte toByte(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Byte.class);
        if (n instanceof Byte) {
            return (Byte)n;
        }
        return new Byte(n.byteValue());
    }

    public static Short toShort(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Short.class);
        if (n instanceof Short) {
            return (Short)n;
        }
        return new Short(n.shortValue());
    }

    public static Integer toInteger(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Integer.class);
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return new Integer(n.intValue());
    }

    public static Long toLong(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Long.class);
        if (n instanceof Long) {
            return (Long)n;
        }
        return new Long(n.longValue());
    }

    public static Float toFloat(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Float.class);
        if (n instanceof Float) {
            return (Float)n;
        }
        return new Float(n.floatValue());
    }

    public static Double toDouble(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, Double.class);
        if (n instanceof Double) {
            return (Double)n;
        }
        return new Double(n.doubleValue());
    }

    public static BigInteger toBigInteger(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, BigInteger.class);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        return BigInteger.valueOf(n.longValue());
    }

    public static BigDecimal toBigDecimal(Object value) throws ConversionException {
        Number n = PropertyConverter.toNumber(value, BigDecimal.class);
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        return new BigDecimal(n.doubleValue());
    }

    static Number toNumber(Object value, Class<?> targetClass) throws ConversionException {
        if (value instanceof Number) {
            return (Number)value;
        }
        String str = value.toString();
        if (str.startsWith(HEX_PREFIX)) {
            try {
                return new BigInteger(str.substring(HEX_PREFIX.length()), 16);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid hex number.", nex);
            }
        }
        if (str.startsWith(BIN_PREFIX)) {
            try {
                return new BigInteger(str.substring(BIN_PREFIX.length()), 2);
            }
            catch (NumberFormatException nex) {
                throw new ConversionException("Could not convert " + str + " to " + targetClass.getName() + "! Invalid binary number.", nex);
            }
        }
        try {
            Constructor<?> constr = targetClass.getConstructor(CONSTR_ARGS);
            return (Number)constr.newInstance(str);
        }
        catch (InvocationTargetException itex) {
            throw new ConversionException("Could not convert " + str + " to " + targetClass.getName(), itex.getTargetException());
        }
        catch (Exception ex) {
            throw new ConversionException("Conversion error when trying to convert " + str + " to " + targetClass.getName(), ex);
        }
    }

    public static URL toURL(Object value) throws ConversionException {
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            try {
                return new URL((String)value);
            }
            catch (MalformedURLException e) {
                throw new ConversionException("The value " + value + " can't be converted to an URL", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to an URL");
    }

    public static Locale toLocale(Object value) throws ConversionException {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof String) {
            List<String> elements = PropertyConverter.split((String)value, '_');
            int size = elements.size();
            if (size >= 1 && (elements.get(0).length() == 2 || elements.get(0).length() == 0)) {
                String language = elements.get(0);
                String country = size >= 2 ? elements.get(1) : "";
                String variant = size >= 3 ? elements.get(2) : "";
                return new Locale(language, country, variant);
            }
            throw new ConversionException("The value " + value + " can't be converted to a Locale");
        }
        throw new ConversionException("The value " + value + " can't be converted to a Locale");
    }

    public static List<String> split(String s2, char delimiter, boolean trim) {
        if (s2 == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        boolean inEscape = false;
        for (int begin = 0; begin < s2.length(); ++begin) {
            char c = s2.charAt(begin);
            if (inEscape) {
                if (c != delimiter && c != '\\') {
                    token.append('\\');
                }
                token.append(c);
                inEscape = false;
                continue;
            }
            if (c == delimiter) {
                String t2 = token.toString();
                if (trim) {
                    t2 = t2.trim();
                }
                list.add(t2);
                token = new StringBuilder();
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            token.append(c);
        }
        if (inEscape) {
            token.append('\\');
        }
        String t3 = token.toString();
        if (trim) {
            t3 = t3.trim();
        }
        list.add(t3);
        return list;
    }

    public static List<String> split(String s2, char delimiter) {
        return PropertyConverter.split(s2, delimiter, true);
    }

    public static String escapeDelimiters(String s2, char delimiter) {
        String s1 = StringUtils.replace(s2, LIST_ESCAPE, LIST_ESCAPE + LIST_ESCAPE);
        return PropertyConverter.escapeListDelimiter(s1, delimiter);
    }

    public static String escapeListDelimiter(String s2, char delimiter) {
        return StringUtils.replace(s2, String.valueOf(delimiter), LIST_ESCAPE + delimiter);
    }

    public static Color toColor(Object value) throws ConversionException {
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value instanceof String && !StringUtils.isBlank((String)value)) {
            String color = ((String)value).trim();
            int[] components = new int[3];
            int minlength = components.length * 2;
            if (color.length() < minlength) {
                throw new ConversionException("The value " + value + " can't be converted to a Color");
            }
            if (color.startsWith("#")) {
                color = color.substring(1);
            }
            try {
                for (int i = 0; i < components.length; ++i) {
                    components[i] = Integer.parseInt(color.substring(2 * i, 2 * i + 2), 16);
                }
                int alpha = color.length() >= minlength + 2 ? Integer.parseInt(color.substring(minlength, minlength + 2), 16) : Color.black.getAlpha();
                return new Color(components[0], components[1], components[2], alpha);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a Color", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Color");
    }

    static InetAddress toInetAddress(Object value) throws ConversionException {
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            try {
                return InetAddress.getByName((String)value);
            }
            catch (UnknownHostException e) {
                throw new ConversionException("The value " + value + " can't be converted to a InetAddress", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a InetAddress");
    }

    static Object toInternetAddress(Object value) throws ConversionException {
        if (value.getClass().getName().equals(INTERNET_ADDRESS_CLASSNAME)) {
            return value;
        }
        if (value instanceof String) {
            try {
                Constructor<?> ctor = Class.forName(INTERNET_ADDRESS_CLASSNAME).getConstructor(String.class);
                return ctor.newInstance(value);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a InternetAddress", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a InternetAddress");
    }

    static boolean isEnum(Class<?> cls) {
        return cls.isEnum();
    }

    static <E extends Enum<E>> E toEnum(Object value, Class<E> cls) throws ConversionException {
        if (value.getClass().equals(cls)) {
            return (E)((Enum)cls.cast(value));
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(cls, (String)value);
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a " + cls.getName());
            }
        }
        if (value instanceof Number) {
            try {
                Enum[] enumConstants = (Enum[])cls.getEnumConstants();
                return (E)enumConstants[((Number)value).intValue()];
            }
            catch (Exception e) {
                throw new ConversionException("The value " + value + " can't be converted to a " + cls.getName());
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a " + cls.getName());
    }

    public static Date toDate(Object value, String format) throws ConversionException {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof String) {
            try {
                return new SimpleDateFormat(format).parse((String)value);
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Date", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Date");
    }

    public static Calendar toCalendar(Object value, String format) throws ConversionException {
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        if (value instanceof String) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse((String)value));
                return calendar;
            }
            catch (ParseException e) {
                throw new ConversionException("The value " + value + " can't be converted to a Calendar", e);
            }
        }
        throw new ConversionException("The value " + value + " can't be converted to a Calendar");
    }

    public static Iterator<?> toIterator(Object value, char delimiter) {
        return PropertyConverter.flatten(value, delimiter).iterator();
    }

    private static Collection<?> flatten(Object value, char delimiter) {
        String s2;
        if (value instanceof String && (s2 = (String)value).indexOf(delimiter) > 0) {
            return PropertyConverter.split(s2, delimiter);
        }
        LinkedList<Object> result = new LinkedList<Object>();
        if (value instanceof Iterable) {
            PropertyConverter.flattenIterator(result, ((Iterable)value).iterator(), delimiter);
        } else if (value instanceof Iterator) {
            PropertyConverter.flattenIterator(result, (Iterator)value, delimiter);
        } else if (value != null) {
            if (value.getClass().isArray()) {
                int len = Array.getLength(value);
                for (int idx = 0; idx < len; ++idx) {
                    result.addAll(PropertyConverter.flatten(Array.get(value, idx), delimiter));
                }
            } else {
                result.add(value);
            }
        }
        return result;
    }

    private static void flattenIterator(Collection<Object> target, Iterator<?> it, char delimiter) {
        while (it.hasNext()) {
            target.addAll(PropertyConverter.flatten(it.next(), delimiter));
        }
    }

    public static Object interpolate(Object value, AbstractConfiguration config) {
        if (value instanceof String) {
            return config.getSubstitutor().replace((String)value);
        }
        return value;
    }

    private static Object convertToEnum(Class<?> enumClass, Object value) {
        return PropertyConverter.toEnum(value, enumClass.asSubclass(Enum.class));
    }
}

