/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl.crypto;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECKey;
import oadd.io.jsonwebtoken.JwtException;
import oadd.io.jsonwebtoken.SignatureAlgorithm;
import oadd.io.jsonwebtoken.SignatureException;
import oadd.io.jsonwebtoken.impl.crypto.EllipticCurveProvider;
import oadd.io.jsonwebtoken.impl.crypto.Signer;

public class EllipticCurveSigner
extends EllipticCurveProvider
implements Signer {
    public EllipticCurveSigner(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        if (!(key instanceof PrivateKey) || !(key instanceof ECKey)) {
            String msg = "Elliptic Curve signatures must be computed using an EC PrivateKey.  The specified key of type " + key.getClass().getName() + " is not an EC PrivateKey.";
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public byte[] sign(byte[] data) {
        try {
            return this.doSign(data);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Invalid Elliptic Curve PrivateKey. " + e.getMessage(), e);
        }
        catch (java.security.SignatureException e) {
            throw new SignatureException("Unable to calculate signature using Elliptic Curve PrivateKey. " + e.getMessage(), e);
        }
        catch (JwtException e) {
            throw new SignatureException("Unable to convert signature to JOSE format. " + e.getMessage(), e);
        }
    }

    protected byte[] doSign(byte[] data) throws InvalidKeyException, java.security.SignatureException, JwtException {
        PrivateKey privateKey = (PrivateKey)this.key;
        Signature sig = this.createSignatureInstance();
        sig.initSign(privateKey);
        sig.update(data);
        return EllipticCurveSigner.transcodeSignatureToConcat(sig.sign(), EllipticCurveSigner.getSignatureByteArrayLength(this.alg));
    }
}

