
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/*
 * This class is automatically generated from AggrTypeFunctions1.tdd using FreeMarker.
 */

package org.apache.drill.exec.expr.fn.impl.gaggr;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.exception.OutOfMemoryException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;






import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import io.netty.buffer.ByteBuf;

/*
 * This class is generated using freemarker and the Decimal/DecimalAggrTypeFunctions1.java template.
 */

@SuppressWarnings("unused")

public class DecimalSumZeroFunctions {

  @FunctionTemplate(name = "$sum0",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_SUM_AGGREGATE)
  public static class VarDecimalSumZero implements DrillAggFunc {
    @Param VarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace ObjectHolder value;
    @Workspace IntHolder outputScale;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;

    public void setup() {
      value = new ObjectHolder();
      value.obj = java.math.BigDecimal.ZERO;
      outputScale = new IntHolder();
      outputScale.value = Integer.MIN_VALUE;
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {
      nonNullCount.value = 1;
      java.math.BigDecimal currentValue = org.apache.drill.exec.util.DecimalUtility
          .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
      value.obj = ((java.math.BigDecimal) value.obj).add(currentValue);
      if (outputScale.value == Integer.MIN_VALUE) {
        outputScale.value = in.scale;
      }
      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow((java.math.BigDecimal) value.obj,
          org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), outputScale.value);
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        out.start  = 0;
        out.scale = outputScale.value;
        out.precision =
            org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
        value.obj = ((java.math.BigDecimal) value.obj).setScale(out.scale, java.math.BigDecimal.ROUND_HALF_UP);
        byte[] bytes = ((java.math.BigDecimal) value.obj).unscaledValue().toByteArray();
        int len = bytes.length;
        out.buffer = buffer = buffer.reallocIfNeeded(len);
        out.buffer.setBytes(0, bytes);
        out.end = len;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      value = new ObjectHolder();
      value.obj = java.math.BigDecimal.ZERO;
      outputScale = new IntHolder();
      outputScale.value = Integer.MIN_VALUE;
      nonNullCount.value = 0;
    }
  }
  @FunctionTemplate(name = "$sum0",
                    scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE,
                    returnType = FunctionTemplate.ReturnType.DECIMAL_SUM_AGGREGATE)
  public static class NullableVarDecimalSumZero implements DrillAggFunc {
    @Param NullableVarDecimalHolder in;
    @Inject DrillBuf buffer;
    @Workspace ObjectHolder value;
    @Workspace IntHolder outputScale;
    @Output NullableVarDecimalHolder out;
    @Workspace BigIntHolder nonNullCount;

    public void setup() {
      value = new ObjectHolder();
      value.obj = java.math.BigDecimal.ZERO;
      outputScale = new IntHolder();
      outputScale.value = Integer.MIN_VALUE;
      nonNullCount = new BigIntHolder();
    }

    @Override
    public void add() {
      sout: {
        if (in.isSet == 0) {
          // processing nullable input and the value is null, so don't do anything...
          break sout;
        }
      nonNullCount.value = 1;
      java.math.BigDecimal currentValue = org.apache.drill.exec.util.DecimalUtility
          .getBigDecimalFromDrillBuf(in.buffer, in.start, in.end - in.start, in.scale);
      value.obj = ((java.math.BigDecimal) value.obj).add(currentValue);
      if (outputScale.value == Integer.MIN_VALUE) {
        outputScale.value = in.scale;
      }
      org.apache.drill.exec.util.DecimalUtility.checkValueOverflow((java.math.BigDecimal) value.obj,
          org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision(), outputScale.value);
      } // end of sout block
    }

    @Override
    public void output() {
      if (nonNullCount.value > 0) {
        out.isSet = 1;
        out.start  = 0;
        out.scale = outputScale.value;
        out.precision =
            org.apache.drill.exec.planner.types.DrillRelDataTypeSystem.DRILL_REL_DATATYPE_SYSTEM.getMaxNumericPrecision();
        value.obj = ((java.math.BigDecimal) value.obj).setScale(out.scale, java.math.BigDecimal.ROUND_HALF_UP);
        byte[] bytes = ((java.math.BigDecimal) value.obj).unscaledValue().toByteArray();
        int len = bytes.length;
        out.buffer = buffer = buffer.reallocIfNeeded(len);
        out.buffer.setBytes(0, bytes);
        out.end = len;
      } else {
        out.isSet = 0;
      }
    }

    @Override
    public void reset() {
      value = new ObjectHolder();
      value.obj = java.math.BigDecimal.ZERO;
      outputScale = new IntHolder();
      outputScale.value = Integer.MIN_VALUE;
      nonNullCount.value = 0;
    }
  }
}
