
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

/*
 * This class is generated using freemarker and the IsEmptyDataFunctions.java template.
 */
public class IsEmptyRepeatedFunctions {

  private IsEmptyRepeatedFunctions() {
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedBit implements DrillSimpleFunc {

    @Param
    RepeatedBitHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedInt implements DrillSimpleFunc {

    @Param
    RepeatedIntHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedBigInt implements DrillSimpleFunc {

    @Param
    RepeatedBigIntHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedFloat4 implements DrillSimpleFunc {

    @Param
    RepeatedFloat4Holder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedFloat8 implements DrillSimpleFunc {

    @Param
    RepeatedFloat8Holder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDate implements DrillSimpleFunc {

    @Param
    RepeatedDateHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedTimeStamp implements DrillSimpleFunc {

    @Param
    RepeatedTimeStampHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedTime implements DrillSimpleFunc {

    @Param
    RepeatedTimeHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedIntervalDay implements DrillSimpleFunc {

    @Param
    RepeatedIntervalDayHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedIntervalYear implements DrillSimpleFunc {

    @Param
    RepeatedIntervalYearHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedInterval implements DrillSimpleFunc {

    @Param
    RepeatedIntervalHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedVarChar implements DrillSimpleFunc {

    @Param
    RepeatedVarCharHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedVarBinary implements DrillSimpleFunc {

    @Param
    RepeatedVarBinaryHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedVarDecimal implements DrillSimpleFunc {

    @Param
    RepeatedVarDecimalHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDecimal9 implements DrillSimpleFunc {

    @Param
    RepeatedDecimal9Holder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDecimal18 implements DrillSimpleFunc {

    @Param
    RepeatedDecimal18Holder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDecimal28Sparse implements DrillSimpleFunc {

    @Param
    RepeatedDecimal28SparseHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDecimal38Sparse implements DrillSimpleFunc {

    @Param
    RepeatedDecimal38SparseHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedList implements DrillSimpleFunc {

    @Param
    RepeatedListHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedMap implements DrillSimpleFunc {

    @Param
    RepeatedMapHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {"isempty", "is_empty"}, scope = FunctionTemplate.FunctionScope.SIMPLE)
  public static class ContainsDataRepeatedRepeatedDict implements DrillSimpleFunc {

    @Param
    RepeatedDictHolder input;
    @Output
    BitHolder out;

    @Override
    public void setup() {
    }

    @Override
    public void eval() {
      out.value = input.reader.size() != 0 ? 1 : 0;
    }
  }

}
