/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the NewValueFunctions.java template.
 */
public class GNewValueFunctions {

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTinyIntNullable implements DrillSimpleFunc {

  @Param NullableTinyIntHolder in;
  @Workspace NullableTinyIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTinyInt implements DrillSimpleFunc {

  @Param TinyIntHolder in;
  @Workspace TinyIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt1Nullable implements DrillSimpleFunc {

  @Param NullableUInt1Holder in;
  @Workspace NullableUInt1Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt1 implements DrillSimpleFunc {

  @Param UInt1Holder in;
  @Workspace UInt1Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt2Nullable implements DrillSimpleFunc {

  @Param NullableUInt2Holder in;
  @Workspace NullableUInt2Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt2 implements DrillSimpleFunc {

  @Param UInt2Holder in;
  @Workspace UInt2Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueSmallIntNullable implements DrillSimpleFunc {

  @Param NullableSmallIntHolder in;
  @Workspace NullableSmallIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueSmallInt implements DrillSimpleFunc {

  @Param SmallIntHolder in;
  @Workspace SmallIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueIntNullable implements DrillSimpleFunc {

  @Param NullableIntHolder in;
  @Workspace NullableIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueInt implements DrillSimpleFunc {

  @Param IntHolder in;
  @Workspace IntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt4Nullable implements DrillSimpleFunc {

  @Param NullableUInt4Holder in;
  @Workspace NullableUInt4Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt4 implements DrillSimpleFunc {

  @Param UInt4Holder in;
  @Workspace UInt4Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueFloat4Nullable implements DrillSimpleFunc {

  @Param NullableFloat4Holder in;
  @Workspace NullableFloat4Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueFloat4 implements DrillSimpleFunc {

  @Param Float4Holder in;
  @Workspace Float4Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTimeNullable implements DrillSimpleFunc {

  @Param NullableTimeHolder in;
  @Workspace NullableTimeHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTime implements DrillSimpleFunc {

  @Param TimeHolder in;
  @Workspace TimeHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

 

 

 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDecimal9Nullable implements DrillSimpleFunc {

  @Param NullableDecimal9Holder in;
  @Workspace NullableDecimal9Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDecimal9 implements DrillSimpleFunc {

  @Param Decimal9Holder in;
  @Workspace Decimal9Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueBigIntNullable implements DrillSimpleFunc {

  @Param NullableBigIntHolder in;
  @Workspace NullableBigIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueBigInt implements DrillSimpleFunc {

  @Param BigIntHolder in;
  @Workspace BigIntHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt8Nullable implements DrillSimpleFunc {

  @Param NullableUInt8Holder in;
  @Workspace NullableUInt8Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueUInt8 implements DrillSimpleFunc {

  @Param UInt8Holder in;
  @Workspace UInt8Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueFloat8Nullable implements DrillSimpleFunc {

  @Param NullableFloat8Holder in;
  @Workspace NullableFloat8Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueFloat8 implements DrillSimpleFunc {

  @Param Float8Holder in;
  @Workspace Float8Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDateNullable implements DrillSimpleFunc {

  @Param NullableDateHolder in;
  @Workspace NullableDateHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDate implements DrillSimpleFunc {

  @Param DateHolder in;
  @Workspace DateHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTimeStampNullable implements DrillSimpleFunc {

  @Param NullableTimeStampHolder in;
  @Workspace NullableTimeStampHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueTimeStamp implements DrillSimpleFunc {

  @Param TimeStampHolder in;
  @Workspace TimeStampHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDecimal18Nullable implements DrillSimpleFunc {

  @Param NullableDecimal18Holder in;
  @Workspace NullableDecimal18Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueDecimal18 implements DrillSimpleFunc {

  @Param Decimal18Holder in;
  @Workspace Decimal18Holder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

 

 

 

 
 

 

 

 

 
 

 

 

 

 
 

 

 

 

 
 

 

 

 

 
 

 

 

 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarBinaryNullable implements DrillSimpleFunc {

  @Param NullableVarBinaryHolder in;
  @Workspace NullableVarBinaryHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
 

    int length = in.isSet == 0 ? 0 : in.end - in.start;

    if (initialized) {
      if (previous.isSet == 0 && in.isSet == 0) {
        out.value = 0;
      } else if (previous.isSet != 0 && in.isSet != 0 && org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        }
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      }
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarBinary implements DrillSimpleFunc {

  @Param VarBinaryHolder in;
  @Workspace VarBinaryHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
    int length = in.end - in.start;

    if (initialized) {
      if (org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        out.value = 1;
      }
    } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarCharNullable implements DrillSimpleFunc {

  @Param NullableVarCharHolder in;
  @Workspace NullableVarCharHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
 

    int length = in.isSet == 0 ? 0 : in.end - in.start;

    if (initialized) {
      if (previous.isSet == 0 && in.isSet == 0) {
        out.value = 0;
      } else if (previous.isSet != 0 && in.isSet != 0 && org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        }
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      }
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarChar implements DrillSimpleFunc {

  @Param VarCharHolder in;
  @Workspace VarCharHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
    int length = in.end - in.start;

    if (initialized) {
      if (org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        out.value = 1;
      }
    } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVar16CharNullable implements DrillSimpleFunc {

  @Param NullableVar16CharHolder in;
  @Workspace NullableVar16CharHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
 

    int length = in.isSet == 0 ? 0 : in.end - in.start;

    if (initialized) {
      if (previous.isSet == 0 && in.isSet == 0) {
        out.value = 0;
      } else if (previous.isSet != 0 && in.isSet != 0 && org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        }
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      }
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVar16Char implements DrillSimpleFunc {

  @Param Var16CharHolder in;
  @Workspace Var16CharHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
    int length = in.end - in.start;

    if (initialized) {
      if (org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        out.value = 1;
      }
    } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarDecimalNullable implements DrillSimpleFunc {

  @Param NullableVarDecimalHolder in;
  @Workspace NullableVarDecimalHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
 

    int length = in.isSet == 0 ? 0 : in.end - in.start;

    if (initialized) {
      if (previous.isSet == 0 && in.isSet == 0) {
        out.value = 0;
      } else if (previous.isSet != 0 && in.isSet != 0 && org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        }
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      if (in.isSet == 1) {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      }
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueVarDecimal implements DrillSimpleFunc {

  @Param VarDecimalHolder in;
  @Workspace VarDecimalHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;
  @Inject DrillBuf buf;

  public void setup() {
    initialized = false;
    previous.buffer = buf;
    previous.start = 0;
  }

  public void eval() {
    int length = in.end - in.start;

    if (initialized) {
      if (org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers.compare(
          previous.buffer, 0, previous.end, in.buffer, in.start, in.end) == 0) {
        out.value = 0;
      } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
        out.value = 1;
      }
    } else {
        previous.buffer = buf = buf.reallocIfNeeded(length);
        previous.buffer.setBytes(0, in.buffer, in.start, length);
        previous.end = length;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueBitNullable implements DrillSimpleFunc {

  @Param NullableBitHolder in;
  @Workspace NullableBitHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
 

    if (initialized) {
      if (in.isSet == 0 && previous.isSet == 0) {
        out.value = 0;
      } else if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        previous.isSet = in.isSet;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      previous.isSet = in.isSet;
      out.value = 1;
      initialized = true;
    }
   
  }
}
 

 

@SuppressWarnings("unused")
@FunctionTemplate(name = "newPartitionValue", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls = NullHandling.INTERNAL)
public static class NewValueBit implements DrillSimpleFunc {

  @Param BitHolder in;
  @Workspace BitHolder previous;
  @Workspace Boolean initialized;
  @Output BitHolder out;

  public void setup() {
    initialized = false;
  }

  public void eval() {
    if (initialized) {
      if (in.value == previous.value) {
        out.value = 0;
      } else {
        previous.value = in.value;
        out.value = 1;
      }
    } else {
      previous.value = in.value;
      out.value = 1;
      initialized = true;
    }
   

 
  }
}
 

 
 
}
