/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import org.apache.drill.yarn.client.CleanCommand;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientContext;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.CommandLineOptions;
import org.apache.drill.yarn.client.HelpCommand;
import org.apache.drill.yarn.client.PrintConfigCommand;
import org.apache.drill.yarn.client.ResizeCommand;
import org.apache.drill.yarn.client.StartCommand;
import org.apache.drill.yarn.client.StatusCommand;
import org.apache.drill.yarn.client.StopCommand;
import org.apache.drill.yarn.core.DoyConfigException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.log4j.BasicConfigurator;

public class DrillOnYarn {
    public static void main(String[] argv) {
        BasicConfigurator.configure();
        ClientContext.init();
        DrillOnYarn.run(argv);
    }

    public static void run(String[] argv) {
        ClientCommand cmd;
        ClientContext context = ClientContext.instance();
        CommandLineOptions opts = new CommandLineOptions();
        if (!opts.parse(argv)) {
            opts.usage();
            context.exit(-1);
        }
        if (opts.getCommand() == null) {
            opts.usage();
            context.exit(-1);
        }
        try {
            DrillOnYarnConfig.load().setClientPaths();
        }
        catch (DoyConfigException e) {
            ClientContext.err.println(e.getMessage());
            context.exit(-1);
        }
        switch (opts.getCommand()) {
            case UPLOAD: {
                cmd = new StartCommand(true, false);
                break;
            }
            case START: {
                cmd = new StartCommand(true, true);
                break;
            }
            case DESCRIBE: {
                cmd = new PrintConfigCommand();
                break;
            }
            case STATUS: {
                cmd = new StatusCommand();
                break;
            }
            case STOP: {
                cmd = new StopCommand();
                break;
            }
            case CLEAN: {
                cmd = new CleanCommand();
                break;
            }
            case RESIZE: {
                cmd = new ResizeCommand();
                break;
            }
            default: {
                cmd = new HelpCommand();
            }
        }
        cmd.setOpts(opts);
        try {
            cmd.run();
        }
        catch (ClientException e) {
            DrillOnYarn.displayError(opts, e);
            context.exit(1);
        }
    }

    private static void displayError(CommandLineOptions opts, ClientException e) {
        ClientContext.err.println(e.getMessage());
        Throwable parent = e;
        for (Throwable cause = e.getCause(); cause != null && cause != parent; cause = cause.getCause()) {
            ClientContext.err.print("  Caused by: ");
            ClientContext.err.println(cause.getMessage());
            parent = cause;
        }
        if (opts.verbose) {
            ClientContext.err.println("Full stack trace:");
            e.printStackTrace(ClientContext.err);
        }
    }
}

