/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.core;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.LaunchSpec;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.Records;

public class AppSpec
extends LaunchSpec {
    private static final Log LOG = LogFactory.getLog(LaunchSpec.class);
    public int memoryMb;
    public int vCores = 1;
    public double disks;
    public String appName;
    public String queueName = "default";
    public int priority = 1;
    public boolean unmanaged;
    public String nodeLabelExpr;

    public ApplicationSubmissionContext createAppLaunchContext(YarnConfiguration conf, YarnClientApplication app) throws IOException {
        ContainerLaunchContext amContainer = this.createLaunchContext(conf);
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        appContext.setApplicationName(this.appName);
        appContext.setAMContainerSpec(amContainer);
        appContext.setResource(this.getCapability());
        appContext.setQueue(this.queueName);
        appContext.setPriority(Priority.newInstance((int)this.priority));
        if (!DoYUtil.isBlank(this.nodeLabelExpr)) {
            LOG.info((Object)("Requesting to run the AM using node expression: " + this.nodeLabelExpr));
            appContext.setNodeLabelExpression(this.nodeLabelExpr);
        }
        appContext.setUnmanagedAM(this.unmanaged);
        appContext.setMaxAppAttempts(1);
        return appContext;
    }

    public Resource getCapability() {
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.memoryMb);
        capability.setVirtualCores(this.vCores);
        DoYUtil.callSetDiskIfExists(capability, this.disks);
        return capability;
    }

    @Override
    public void dump(PrintStream out) {
        out.print("Memory (MB): ");
        out.println(this.memoryMb);
        out.print("Vcores: ");
        out.println(this.vCores);
        out.print("Disks: ");
        out.println(this.disks);
        out.print("Application Name: ");
        out.println(this.appName);
        out.print("Queue: ");
        out.println(this.queueName);
        out.print("Priority: ");
        out.println(this.priority);
        super.dump(out);
    }
}

