/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.client.SimpleRestClient;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.YarnClientException;
import org.apache.drill.yarn.core.YarnRMClient;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class StatusCommand
extends ClientCommand {
    public static String getAmUrl(ApplicationReport report) {
        return DoYUtil.unwrapAmUrl(report.getOriginalTrackingUrl());
    }

    @Override
    public void run() throws ClientException {
        YarnRMClient client = this.getClient();
        System.out.println("Application ID: " + client.getAppId().toString());
        Reporter reporter = new Reporter(client);
        try {
            reporter.getReport();
        }
        catch (Exception e) {
            this.removeAppIdFile();
            System.out.println("Application is not running.");
            return;
        }
        reporter.display(this.opts.verbose, false);
        if (reporter.isRunning()) {
            this.showAmStatus(reporter.report);
        }
    }

    private void showAmStatus(ApplicationReport report) {
        try {
            String baseUrl = StatusCommand.getAmUrl(report);
            if (DoYUtil.isBlank(baseUrl)) {
                return;
            }
            SimpleRestClient restClient = new SimpleRestClient();
            String tail = "rest/status";
            if (this.opts.verbose) {
                System.out.println("Getting status with " + baseUrl + "/" + tail);
            }
            String result = restClient.send(baseUrl, tail, false);
            this.formatResponse(result);
            System.out.println("For more information, visit: " + baseUrl);
        }
        catch (ClientException e) {
            System.out.println("Failed to get AM status");
            System.err.println(e.getMessage());
        }
    }

    private void formatResponse(String result) {
        Object status;
        JSONParser parser = new JSONParser();
        try {
            status = parser.parse(result);
        }
        catch (ParseException e) {
            System.err.println("Invalid response received from AM");
            if (this.opts.verbose) {
                System.out.println(result);
                System.out.println(e.getMessage());
            }
            return;
        }
        JSONObject root = (JSONObject)status;
        this.showMetric("AM State", root, "state");
        this.showMetric("Target Drillbit Count", root.get((Object)"summary"), "targetBitCount");
        this.showMetric("Live Drillbit Count", root.get((Object)"summary"), "liveBitCount");
        this.showMetric("Unmanaged Drillbit Count", root.get((Object)"summary"), "unmanagedCount");
        this.showMetric("Blacklisted Node Count", root.get((Object)"summary"), "blackListCount");
        this.showMetric("Free Node Count", root.get((Object)"summary"), "freeNodeCount");
    }

    private void showMetric(String label, Object object, String key) {
        if (object == null) {
            return;
        }
        if (!(object instanceof JSONObject)) {
            return;
        }
        if ((object = ((JSONObject)object).get((Object)key)) == null) {
            return;
        }
        System.out.println(label + ": " + object.toString());
    }

    public static class Reporter {
        private YarnRMClient client;
        ApplicationReport report;

        public Reporter(YarnRMClient client) {
            this.client = client;
        }

        public void getReport() throws ClientException {
            try {
                this.report = this.client.getAppReport();
            }
            catch (YarnClientException e) {
                throw new ClientException("Failed to get report for Drill application master", e);
            }
        }

        public void display(boolean verbose, boolean isNew) {
            YarnApplicationState state = this.report.getYarnApplicationState();
            if (verbose || !isNew) {
                System.out.println("Application State: " + state.toString());
                System.out.println("Host: " + this.report.getHost());
            }
            if (verbose || !isNew) {
                System.out.println("Queue: " + this.report.getQueue());
                System.out.println("User: " + this.report.getUser());
                long startTime = this.report.getStartTime();
                System.out.println("Start Time: " + DoYUtil.toIsoTime(startTime));
                System.out.println("Application Name: " + this.report.getName());
            }
            System.out.println("Tracking URL: " + this.report.getTrackingUrl());
            if (isNew) {
                System.out.println("Application Master URL: " + this.getAmUrl());
            }
            this.showFinalStatus();
        }

        public String getAmUrl() {
            return StatusCommand.getAmUrl(this.report);
        }

        public void showFinalStatus() {
            YarnApplicationState state = this.report.getYarnApplicationState();
            if (state == YarnApplicationState.FAILED || state == YarnApplicationState.FINISHED) {
                String diag;
                FinalApplicationStatus status = this.report.getFinalApplicationStatus();
                System.out.println("Final status: " + status.toString());
                if (status != FinalApplicationStatus.SUCCEEDED && !DoYUtil.isBlank(diag = this.report.getDiagnostics())) {
                    System.out.println("Diagnostics: " + diag);
                }
            }
        }

        public YarnApplicationState getState() {
            return this.report.getYarnApplicationState();
        }

        public boolean isStarting() {
            YarnApplicationState state = this.getState();
            return state == YarnApplicationState.ACCEPTED || state == YarnApplicationState.NEW || state == YarnApplicationState.NEW_SAVING || state == YarnApplicationState.SUBMITTED;
        }

        public boolean isStopped() {
            YarnApplicationState state = this.getState();
            return state == YarnApplicationState.FAILED || state == YarnApplicationState.FINISHED || state == YarnApplicationState.KILLED;
        }

        public boolean isRunning() {
            YarnApplicationState state = this.getState();
            return state == YarnApplicationState.RUNNING;
        }
    }
}

