/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.client;

import com.typesafe.config.Config;
import java.io.File;
import org.apache.drill.yarn.client.ClientCommand;
import org.apache.drill.yarn.client.ClientException;
import org.apache.drill.yarn.core.DfsFacade;
import org.apache.drill.yarn.core.DrillOnYarnConfig;

public class CleanCommand
extends ClientCommand {
    private Config config;
    private DfsFacade dfs;

    @Override
    public void run() throws ClientException {
        this.config = DrillOnYarnConfig.config();
        if (!this.isLocalized()) {
            System.out.println("Not using localized files; nothing to clean.");
            return;
        }
        this.connectToDfs();
        this.removeDrillArchive();
        this.removeSiteArchive();
    }

    public boolean isLocalized() {
        return this.config.getBoolean(DrillOnYarnConfig.LOCALIZE_DRILL);
    }

    protected void connectToDfs() throws ClientException {
        try {
            System.out.print("Connecting to DFS...");
            this.dfs = new DfsFacade(this.config);
            this.dfs.connect();
            System.out.println(" Connected.");
        }
        catch (DfsFacade.DfsFacadeException e) {
            System.out.println("Failed.");
            throw new ClientException("Failed to connect to DFS", e);
        }
    }

    private void removeDrillArchive() {
        String localArchivePath = this.config.getString(DrillOnYarnConfig.DRILL_ARCHIVE_PATH);
        String archiveName = new File(localArchivePath).getName();
        this.removeArchive(archiveName);
    }

    private void removeArchive(String archiveName) {
        System.out.print("Removing " + archiveName + " ...");
        try {
            this.dfs.removeDrillFile(archiveName);
            System.out.println(" Removed");
        }
        catch (DfsFacade.DfsFacadeException e) {
            System.out.println();
            System.err.println(e.getMessage());
        }
    }

    private void removeSiteArchive() {
        DrillOnYarnConfig doyConfig = DrillOnYarnConfig.instance();
        if (!doyConfig.hasSiteDir()) {
            return;
        }
        String archiveName = "site.tar.gz";
        this.removeArchive(archiveName);
    }
}

