/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster.http;

import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.scanner.persistence.ScanResult;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticationException;
import org.apache.drill.exec.rpc.user.security.UserAuthenticator;
import org.apache.drill.exec.rpc.user.security.UserAuthenticatorFactory;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.yarn.appMaster.AMWrapperException;
import org.apache.drill.yarn.appMaster.http.AMSecurityManager;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.drill.yarn.core.DrillOnYarnConfig;

public class AMSecurityManagerImpl
implements AMSecurityManager {
    private static final Log LOG = LogFactory.getLog(AMSecurityManagerImpl.class);
    private static AMSecurityManagerImpl instance;
    private AMSecurityManager managerImpl;

    private AMSecurityManagerImpl() {
    }

    public static void setup() {
        instance = new AMSecurityManagerImpl();
        instance.init();
    }

    @Override
    public void init() {
        Config config = DrillOnYarnConfig.config();
        String authType = config.getString(DrillOnYarnConfig.HTTP_AUTH_TYPE);
        if ("drill".equals(authType)) {
            if (config.getBoolean("drill.exec.security.user.auth.enabled")) {
                this.managerImpl = new DrillSecurityManager();
                this.managerImpl.init();
            }
        } else if ("simple".equals(authType)) {
            this.managerImpl = new SimpleSecurityManager();
            this.managerImpl.init();
        } else if (!DoYUtil.isBlank(authType) && !"none".equals(authType)) {
            LOG.error((Object)("Unrecognized authorization type for " + DrillOnYarnConfig.HTTP_AUTH_TYPE + ": " + authType + " - assuming no auth."));
        }
    }

    @Override
    public boolean login(String user, String password) {
        if (this.managerImpl == null) {
            return true;
        }
        return this.managerImpl.login(user, password);
    }

    @Override
    public void close() {
        if (this.managerImpl != null) {
            this.managerImpl.close();
            this.managerImpl = null;
        }
    }

    @Override
    public boolean requiresLogin() {
        return this.managerImpl != null;
    }

    public static AMSecurityManager instance() {
        return instance;
    }

    public static boolean isEnabled() {
        return instance != null && AMSecurityManagerImpl.instance.managerImpl != null;
    }

    private static class SimpleSecurityManager
    implements AMSecurityManager {
        private String userName;
        private String password;

        private SimpleSecurityManager() {
        }

        @Override
        public void init() {
            Config config = DrillOnYarnConfig.config();
            this.userName = config.getString(DrillOnYarnConfig.HTTP_USER_NAME);
            this.password = config.getString(DrillOnYarnConfig.HTTP_PASSWORD);
            if (DoYUtil.isBlank(this.userName)) {
                LOG.warn((Object)("Simple HTTP authentication is enabled, but " + DrillOnYarnConfig.HTTP_USER_NAME + " is blank."));
            }
            if (DoYUtil.isBlank(this.userName)) {
                LOG.warn((Object)("Simple HTTP authentication is enabled, but " + DrillOnYarnConfig.HTTP_PASSWORD + " is blank."));
            }
        }

        @Override
        public boolean requiresLogin() {
            return !DoYUtil.isBlank(this.userName);
        }

        @Override
        public boolean login(String user, String pwd) {
            boolean ok;
            if (!this.requiresLogin()) {
                return true;
            }
            boolean bl = ok = this.userName.equals(user) && this.password.equals(pwd);
            if (!ok) {
                LOG.info((Object)("Failed login attempt with simple authorization for user " + user));
            }
            return ok;
        }

        @Override
        public void close() {
        }
    }

    private static class DrillSecurityManager
    implements AMSecurityManager {
        private UserAuthenticator authenticator;

        private DrillSecurityManager() {
        }

        @Override
        public void init() {
            try {
                DrillOnYarnConfig doyConfig = DrillOnYarnConfig.instance();
                DrillConfig config = doyConfig.getDrillConfig();
                ScanResult classpathScan = doyConfig.getClassPathScan();
                this.authenticator = config.getBoolean("drill.exec.security.user.auth.enabled") ? UserAuthenticatorFactory.createAuthenticator((DrillConfig)config, (ScanResult)classpathScan) : null;
            }
            catch (DrillbitStartupException e) {
                LOG.info((Object)"Authentication initialization failed", (Throwable)e);
                throw new AMWrapperException("Security init failed", (Exception)((Object)e));
            }
        }

        @Override
        public boolean login(String user, String password) {
            if (this.authenticator == null) {
                return true;
            }
            try {
                this.authenticator.authenticate(user, password);
            }
            catch (UserAuthenticationException e) {
                LOG.info((Object)("Authentication failed for user " + user), (Throwable)e);
                return false;
            }
            return ImpersonationUtil.getProcessUserName().equals(user);
        }

        @Override
        public void close() {
            try {
                if (this.authenticator != null) {
                    this.authenticator.close();
                }
            }
            catch (IOException e) {
                LOG.info((Object)"Ignoring error on authenticator close", (Throwable)e);
            }
        }

        @Override
        public boolean requiresLogin() {
            return this.authenticator != null;
        }
    }
}

