/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ClusterControllerImpl;
import org.apache.drill.yarn.appMaster.EventContext;
import org.apache.drill.yarn.appMaster.Scheduler;
import org.apache.drill.yarn.appMaster.SchedulerState;
import org.apache.drill.yarn.appMaster.SchedulerStateActions;
import org.apache.drill.yarn.appMaster.Task;
import org.apache.drill.yarn.appMaster.TaskLifecycleListener;
import org.apache.drill.yarn.appMaster.TaskVisitor;
import org.apache.drill.yarn.core.DoYUtil;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;

public final class SchedulerStateImpl
implements SchedulerState,
SchedulerStateActions {
    static final Log LOG = LogFactory.getLog(SchedulerStateImpl.class);
    private final Scheduler scheduler;
    private final ClusterControllerImpl controller;
    protected List<Task> pendingTasks = new LinkedList<Task>();
    protected List<Task> allocatingTasks = new LinkedList<Task>();
    protected Map<ContainerId, Task> activeContainers = new HashMap<ContainerId, Task>();

    public SchedulerStateImpl(ClusterControllerImpl controller, Scheduler scheduler) {
        this.controller = controller;
        this.scheduler = scheduler;
        scheduler.registerState(this);
    }

    @Override
    public String getName() {
        return this.scheduler.getName();
    }

    public int getMaxRetries() {
        return this.controller.getMaxRetries();
    }

    public int getStopTimeoutMs() {
        return this.controller.getStopTimeoutMs();
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void start(Task task) {
        assert (task.getGroup() == null);
        task.setGroup(this);
        this.enqueuePendingRequest(task);
    }

    public void enqueuePendingRequest(Task task) {
        assert (!this.activeContainers.containsValue(task));
        assert (!this.allocatingTasks.contains(task));
        assert (!this.pendingTasks.contains(task));
        this.pendingTasks.add(task);
        EventContext context = new EventContext(this.controller, task);
        this.controller.fireLifecycleChange(TaskLifecycleListener.Event.CREATED, context);
    }

    public int maxCurrentRequests() {
        return this.scheduler.getTaskManager().maxConcurrentAllocs();
    }

    @Override
    public boolean requestContainers(EventContext context, int maxRequests) {
        if (this.pendingTasks.isEmpty()) {
            return false;
        }
        maxRequests = Math.min(maxRequests, this.maxCurrentRequests());
        maxRequests -= this.allocatingTasks.size();
        for (int i = 0; i < maxRequests && !this.pendingTasks.isEmpty(); ++i) {
            context.setTask(this.pendingTasks.get(0));
            context.getState().requestContainer(context);
        }
        return true;
    }

    public void dequeuePendingRequest(Task task) {
        assert (!this.activeContainers.containsValue(task));
        assert (!this.allocatingTasks.contains(task));
        assert (this.pendingTasks.contains(task));
        this.pendingTasks.remove(task);
    }

    public void enqueueAllocatingTask(Task task) {
        assert (!this.activeContainers.containsValue(task));
        assert (!this.allocatingTasks.contains(task));
        assert (!this.pendingTasks.contains(task));
        this.allocatingTasks.add(task);
    }

    @Override
    public void containerAllocated(EventContext context, Container container) {
        if (this.activeContainers.containsKey(container.getId())) {
            LOG.error((Object)("Container allocated again: " + DoYUtil.labelContainer(container)));
            return;
        }
        if (this.allocatingTasks.isEmpty()) {
            LOG.warn((Object)("Releasing unwanted container: " + DoYUtil.labelContainer(container)));
            context.yarn.releaseContainer(container);
            return;
        }
        context.setTask(this.allocatingTasks.get(0));
        context.getState().containerAllocated(context, container);
    }

    @Override
    public void checkTasks(EventContext context, long curTime) {
        ArrayList<Task> temp = new ArrayList<Task>();
        temp.addAll(this.allocatingTasks);
        for (Task task : temp) {
            context.setTask(task);
            context.getState().tick(context, curTime);
        }
        temp.clear();
        temp.addAll(this.pendingTasks);
        for (Task task : temp) {
            context.setTask(task);
            context.getState().tick(context, curTime);
        }
        temp.clear();
        temp.addAll(this.activeContainers.values());
        for (Task task : temp) {
            context.setTask(task);
            context.getState().tick(context, curTime);
        }
    }

    public void dequeueAllocatingTask(Task task) {
        assert (this.allocatingTasks.contains(task));
        this.allocatingTasks.remove(task);
    }

    public void containerAllocated(Task task) {
        assert (!this.activeContainers.containsValue(task));
        assert (!this.allocatingTasks.contains(task));
        assert (!this.pendingTasks.contains(task));
        this.activeContainers.put(task.getContainerId(), task);
        this.controller.containerAllocated(task);
    }

    public void containerReleased(Task task) {
        assert (this.activeContainers.containsKey(task.getContainerId()));
        this.activeContainers.remove(task.getContainerId());
        this.controller.containerReleased(task);
    }

    public void taskEnded(Task task) {
        this.scheduler.completed(task);
        this.controller.taskEnded(task);
        if (this.isDone()) {
            this.controller.taskGroupCompleted(this);
        }
        LOG.info((Object)(task.toString() + " - Task completed"));
    }

    public void taskRetried(Task task) {
        this.controller.taskRetried(task);
    }

    @Override
    public void shutDown(EventContext context) {
        for (Task task : this.getStartingTasks()) {
            context.setTask(task);
            context.getState().cancel(context);
        }
        for (Task task : this.getActiveTasks()) {
            context.setTask(task);
            context.getState().cancel(context);
        }
    }

    public boolean hasTasks() {
        return this.getTaskCount() != 0;
    }

    @Override
    public boolean isDone() {
        return !this.hasTasks() && !this.scheduler.hasMoreTasks();
    }

    @Override
    public void adjustTasks() {
        this.scheduler.adjust();
    }

    public boolean requestStop(Task task) {
        return this.scheduler.getTaskManager().stop(task);
    }

    @Override
    public int getTaskCount() {
        return this.pendingTasks.size() + this.allocatingTasks.size() + this.activeContainers.size();
    }

    @Override
    public int getCancelledTaskCount() {
        int count = 0;
        for (Task task : this.pendingTasks) {
            if (!task.isCancelled()) continue;
            ++count;
        }
        for (Task task : this.allocatingTasks) {
            if (!task.isCancelled()) continue;
            ++count;
        }
        for (Task task : this.activeContainers.values()) {
            if (!task.isCancelled()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<Task> getStartingTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Task task : this.pendingTasks) {
            if (task.isCancelled()) continue;
            tasks.add(task);
        }
        for (Task task : this.allocatingTasks) {
            if (task.isCancelled()) continue;
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    public List<Task> getActiveTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (Task task : this.activeContainers.values()) {
            if (task.isCancelled()) continue;
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    public void cancel(Task task) {
        EventContext context = new EventContext(this.controller, task);
        LOG.info((Object)(task.getLabel() + " Task cancelled"));
        context.getState().cancel(context);
    }

    @Override
    public int getLiveCount() {
        int count = 0;
        for (Task task : this.activeContainers.values()) {
            if (!task.isLive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void visitTaskModels(TaskVisitor visitor) {
        for (Task task : this.pendingTasks) {
            visitor.visit(task);
        }
        for (Task task : this.allocatingTasks) {
            visitor.visit(task);
        }
        for (Task task : this.activeContainers.values()) {
            visitor.visit(task);
        }
    }

    @Override
    public Task getTask(int id) {
        for (Task task : this.pendingTasks) {
            if (task.getId() != id) continue;
            return task;
        }
        for (Task task : this.allocatingTasks) {
            if (task.getId() != id) continue;
            return task;
        }
        for (Task task : this.activeContainers.values()) {
            if (task.getId() != id) continue;
            return task;
        }
        return null;
    }

    @Override
    public int getRequestCount() {
        return this.allocatingTasks.size();
    }

    @Override
    public ClusterController getController() {
        return this.controller;
    }
}

