/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PulseRunnable
implements Runnable {
    private static final Log LOG = LogFactory.getLog(PulseRunnable.class);
    private final int pulsePeriod;
    private final PulseCallback callback;
    public AtomicBoolean isLive = new AtomicBoolean(true);

    public PulseRunnable(int pulsePeriodMS, PulseCallback callback) {
        this.pulsePeriod = pulsePeriodMS;
        this.callback = callback;
    }

    @Override
    public void run() {
        while (this.isLive.get()) {
            try {
                Thread.sleep(this.pulsePeriod);
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                this.callback.onTick(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error((Object)"Timer thread caught, ignored an exception", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.isLive.set(false);
    }

    public static interface PulseCallback {
        public void onTick(long var1);
    }
}

