/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.common.util.GuavaPatcher;
import org.apache.drill.common.util.ProtobufPatcher;
import org.apache.drill.yarn.appMaster.ControllerFactory;
import org.apache.drill.yarn.appMaster.Dispatcher;
import org.apache.drill.yarn.appMaster.DrillControllerFactory;
import org.apache.drill.yarn.appMaster.http.WebServer;
import org.apache.drill.yarn.core.DoyConfigException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;

public class DrillApplicationMaster {
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Dispatcher dispatcher;
        LOG.trace((Object)"Drill Application Master starting.");
        try {
            DrillOnYarnConfig.load().setAmDrillHome();
        }
        catch (DoyConfigException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        try {
            dispatcher = new DrillControllerFactory().build();
        }
        catch (ControllerFactory.ControllerFactoryException e) {
            LOG.error((Object)("Setup failed, exiting: " + e.getMessage()), (Throwable)e);
            System.exit(-1);
            return;
        }
        try {
            if (!dispatcher.start()) {
                return;
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Fatal error, exiting: " + e.getMessage()), e);
            System.exit(-1);
        }
        WebServer webServer = new WebServer(dispatcher);
        try {
            webServer.start();
        }
        catch (Exception e) {
            LOG.error((Object)("Web server setup failed, exiting: " + e.getMessage()), (Throwable)e);
            System.exit(-1);
        }
        try {
            dispatcher.run();
        }
        catch (Throwable e) {
            LOG.error((Object)("Fatal error, exiting: " + e.getMessage()), e);
            System.exit(-1);
        }
        finally {
            try {
                webServer.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        ProtobufPatcher.patch();
        GuavaPatcher.patch();
        LOG = LogFactory.getLog(DrillApplicationMaster.class);
    }
}

