/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.drill.yarn.appMaster.AbstractDrillbitScheduler;
import org.apache.drill.yarn.appMaster.TaskSpec;

public class DrillbitScheduler
extends AbstractDrillbitScheduler {
    private int requestTimeoutSecs;
    private int maxExtraNodes;

    public DrillbitScheduler(String name, TaskSpec taskSpec, int quantity, int requestTimeoutSecs, int maxExtraNodes) {
        super("basic", name, quantity);
        this.taskSpec = taskSpec;
        this.requestTimeoutSecs = requestTimeoutSecs;
        this.maxExtraNodes = maxExtraNodes;
    }

    @Override
    public int resize(int level) {
        int limit = this.quantity + this.state.getController().getFreeNodeCount() + this.maxExtraNodes;
        return super.resize(Math.min(limit, level));
    }

    @Override
    public int getRequestTimeoutSec() {
        return this.requestTimeoutSecs;
    }
}

