/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.scripts;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.yarn.scripts.ScriptUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestScripts {
    static ScriptUtils context;

    @BeforeClass
    public static void initialSetup() throws IOException {
        context = ScriptUtils.instance();
        context.initialSetup();
    }

    @Test
    public void testStockCombined() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateStockArgs();
        result.validateClassPath(ScriptUtils.stdCp);
        result.validateStdOut();
        result.validateStdErr();
        result.validateDrillLog();
        String propArg = "-Dproperty=value";
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withArg(propArg).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        result2.validateStdOut();
        result2.validateArg(propArg);
        propArg = "-Dproperty=value";
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_JAVA_OPTS", propArg).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        result2.validateStockArgs();
        result2.validateStdOut();
        result2.validateArg(propArg);
        propArg = "-Dproperty2=value2";
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILLBIT_JAVA_OPTS", propArg).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        result2.validateStockArgs();
        result2.validateStdOut();
        result2.validateArg(propArg);
        propArg = "-Dproperty=value";
        String propArg2 = "-Dproperty2=value2";
        ScriptUtils.RunResult result3 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_JAVA_OPTS", propArg).addEnv("DRILLBIT_JAVA_OPTS", propArg2).run();
        Assert.assertEquals((long)0L, (long)result3.returnCode);
        result3.validateArgs(new String[]{propArg, propArg2});
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_HEAP", "5G").run();
        result.validateArgs(new String[]{"-Xms5G", "-Xmx5G"});
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_MAX_DIRECT_MEMORY", "7G").run();
        result.validateArg("-XX:MaxDirectMemorySize=7G");
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("SERVER_LOG_GC", "1").run();
        String logTail = TestScripts.context.testLogDir.getName() + "/drillbit.gc";
        result.validateArgRegex("-Xloggc:.*/" + logTail);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILLBIT_CODE_CACHE_SIZE", "2G").run();
        result.validateArg("-XX:ReservedCodeCacheSize=2G");
    }

    @Test
    public void testClassPath() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File extrasDir = context.createDir(new File(TestScripts.context.testDir, "extras"));
        File hadoopJar = context.makeDummyJar(extrasDir, "hadoop");
        File hbaseJar = context.makeDummyJar(extrasDir, "hbase");
        File prefixJar = context.makeDummyJar(extrasDir, "prefix");
        File cpJar = context.makeDummyJar(extrasDir, "cp");
        File extnJar = context.makeDummyJar(extrasDir, "extn");
        File toolsJar = context.makeDummyJar(extrasDir, "tools");
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_CLASSPATH_PREFIX", prefixJar.getAbsolutePath()).run();
        result.validateClassPath(prefixJar.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_TOOL_CP", toolsJar.getAbsolutePath()).run();
        result.validateClassPath(toolsJar.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("HADOOP_CLASSPATH", hadoopJar.getAbsolutePath()).run();
        result.validateClassPath(hadoopJar.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("HBASE_CLASSPATH", hbaseJar.getAbsolutePath()).run();
        result.validateClassPath(hbaseJar.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("EXTN_CLASSPATH", extnJar.getAbsolutePath()).run();
        result.validateClassPath(extnJar.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_CLASSPATH", cpJar.getAbsolutePath()).run();
        result.validateClassPath(cpJar.getAbsolutePath());
        File siteJars = new File(siteDir, "jars");
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertFalse((boolean)result2.classPathContains(siteJars.getAbsolutePath()));
        context.createDir(siteJars);
        context.makeDummyJar(siteJars, "site");
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        result2.validateClassPath(siteJars.getAbsolutePath() + "/*");
    }

    @Test
    public void testLogDir() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File logsDir = context.createDir(new File(TestScripts.context.testDir, "logs"));
        context.removeDir(new File(TestScripts.context.testDrillHome, "log"));
        String logPath = logsDir.getAbsolutePath();
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_LOG_DIR", logPath).withLogDir(logsDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(new String[]{"-Dlog.path=" + logPath + "/drillbit.log", "-Dlog.query.path=" + logPath + "/drillbit_queries.json"});
        result.validateStdOut();
        result.validateStdErr();
        result.validateDrillLog();
    }

    @Test
    public void testLibPath() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File logsDir = context.createDir(new File(TestScripts.context.testDir, "logs"));
        context.removeDir(new File(TestScripts.context.testDrillHome, "log"));
        String logPath = logsDir.getAbsolutePath();
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_LOG_DIR", logPath).withLogDir(logsDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(new String[]{"-Dlog.path=" + logPath + "/drillbit.log", "-Dlog.query.path=" + logPath + "/drillbit_queries.json"});
        result.validateStdOut();
        result.validateStdErr();
        result.validateDrillLog();
    }

    @Test
    public void testDrillEnv() throws IOException {
        this.doEnvFileTest("drill-env.sh");
    }

    @Test
    public void testDistribEnv() throws IOException {
        this.doEnvFileTest("distrib-env.sh");
    }

    private void doEnvFileTest(String fileName) throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        String propArg = "-Dproperty=value";
        drillEnv.put("DRILL_JAVA_OPTS", propArg);
        drillEnv.put("DRILL_HEAP", "5G");
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "7G");
        drillEnv.put("SERVER_LOG_GC", "1");
        drillEnv.put("DRILLBIT_CODE_CACHE_SIZE", "2G");
        context.createEnvFile(new File(siteDir, fileName), drillEnv, false);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        String[] expectedArgs = new String[]{propArg, "-Xms5G", "-Xmx5G", "-XX:MaxDirectMemorySize=7G", "-XX:ReservedCodeCacheSize=2G"};
        result.validateArgs(expectedArgs);
        String logTail = TestScripts.context.testLogDir.getName() + "/drillbit.gc";
        result.validateArgRegex("-Xloggc:.*/" + logTail);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("SERVER_LOG_GC", "0").addEnv("DRILL_MAX_DIRECT_MEMORY", "9G").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArg("-XX:MaxDirectMemorySize=9G");
        String logTail2 = TestScripts.context.testDrillHome.getName() + "/log/drillbit.gc";
        Assert.assertFalse((boolean)result.containsArgRegex("-Xloggc:.*/" + logTail2));
    }

    @Test
    public void testDistribEnvWithNegativeCond() throws IOException {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("DRILLBIT_CONTEXT", "0");
        String[] expectedArgs = new String[]{"-XX:ReservedCodeCacheSize=1G"};
        this.doEnvFileWithConditionTest("distrib-env.sh", conditions, expectedArgs);
    }

    @Test
    public void testDistribEnvWithPositiveCond() throws IOException {
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("DRILLBIT_CONTEXT", "1");
        String[] expectedArgs = new String[]{"-XX:ReservedCodeCacheSize=2G"};
        this.doEnvFileWithConditionTest("distrib-env.sh", conditions, expectedArgs);
    }

    private void doEnvFileWithConditionTest(String fileName, Map<String, String> conditions, String[] expectedArgs) throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILLBIT_CODE_CACHE_SIZE", "2G");
        context.createEnvFileWithCondition(new File(siteDir, fileName), conditions, drillEnv, false);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(expectedArgs);
    }

    @Test
    public void testDrillAndDistribEnv() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        HashMap<String, String> distribEnv = new HashMap<String, String>();
        distribEnv.put("DRILL_HEAP", "5G");
        distribEnv.put("DRILL_MAX_DIRECT_MEMORY", "7G");
        context.createEnvFile(new File(siteDir, "distrib-env.sh"), distribEnv, false);
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_HEAP", "6G");
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "9G");
        context.createEnvFile(new File(siteDir, "drill-env.sh"), drillEnv, false);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        String[] expectedArgs = new String[]{"-Xms6G", "-Xmx6G", "-XX:MaxDirectMemorySize=9G", "-XX:ReservedCodeCacheSize=1024m"};
        result.validateArgs(expectedArgs);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_MAX_DIRECT_MEMORY", "5G").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        expectedArgs = new String[]{"-Xms6G", "-Xmx6G", "-XX:MaxDirectMemorySize=5G", "-XX:ReservedCodeCacheSize=1024m"};
        result.validateArgs(expectedArgs);
    }

    @Test
    public void testBadSiteDir() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.removeDir(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertEquals((long)1L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.stderr.contains("Config dir does not exist"));
        context.writeFile(siteDir, "dummy");
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertEquals((long)1L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.stderr.contains("Config dir does not exist"));
        siteDir.delete();
        context.createDir(siteDir);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertEquals((long)1L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.stderr.contains("Drill config file missing"));
    }

    @Test
    public void testSiteDir() throws IOException {
        context.createMockDistrib();
        File confDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createDir(confDir);
        File siteDir = new File(TestScripts.context.testDir, "site");
        context.createMockConf(siteDir);
        context.writeFile(new File(confDir, "drill-env.sh"), "#!/bin/bash\n# Example file");
        File siteJars = new File(siteDir, "jars");
        HashMap<String, String> distribEnv = new HashMap<String, String>();
        distribEnv.put("DRILL_HEAP", "5G");
        distribEnv.put("DRILL_MAX_DIRECT_MEMORY", "7G");
        context.createEnvFile(new File(confDir, "distrib-env.sh"), distribEnv, false);
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_HEAP", "6G");
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "9G");
        context.createEnvFile(new File(siteDir, "drill-env.sh"), drillEnv, false);
        String[] expectedArgs = new String[]{"-Xms6G", "-Xmx6G", "-XX:MaxDirectMemorySize=9G", "-XX:ReservedCodeCacheSize=1024m"};
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withArg("--config").withArg(siteDir.getAbsolutePath()).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(expectedArgs);
        result.validateClassPath(siteDir.getAbsolutePath());
        result = new ScriptUtils.DrillbitRun().withArg("--config").withArg(siteDir.getAbsolutePath()).withArg(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(expectedArgs);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(expectedArgs);
        String propArg = "-Dproperty=value";
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).withArg(propArg).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        result2.validateArgs(expectedArgs);
        result2.validateArg(propArg);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).addEnv("DRILL_CONF_DIR", siteDir.getAbsolutePath()).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArgs(expectedArgs);
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertFalse((boolean)result.classPathContains(siteJars.getAbsolutePath()));
        context.createDir(siteJars);
        context.makeDummyJar(siteJars, "site");
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertTrue((boolean)result.classPathContains(siteJars.getAbsolutePath() + "/*"));
    }

    @Test
    public void testJavaLibDir() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        String prefix = "-Djava.library.path=";
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).run();
        Assert.assertFalse((boolean)result.containsArgRegex(prefix + ".*"));
        Assert.assertNull((Object)result.libPath);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DRILL_JAVA_OPTS", prefix + "/foo/bar:/foo/mumble");
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withEnvironment(env).run();
        Assert.assertTrue((boolean)result2.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result2.libPath);
        Assert.assertEquals((long)2L, (long)result2.libPath.length);
        Assert.assertEquals((Object)"/foo/bar", (Object)result2.libPath[0]);
        Assert.assertEquals((Object)"/foo/mumble", (Object)result2.libPath[1]);
        env = new HashMap();
        env.put("DRILL_JAVA_LIB_PATH", "/foo/bar:/foo/mumble");
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withEnvironment(env).run();
        Assert.assertTrue((boolean)result2.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result2.libPath);
        Assert.assertEquals((long)2L, (long)result2.libPath.length);
        Assert.assertEquals((Object)"/foo/bar", (Object)result2.libPath[0]);
        Assert.assertEquals((Object)"/foo/mumble", (Object)result2.libPath[1]);
        env = new HashMap();
        env.put("DOY_JAVA_LIB_PATH", "/foo/bar:/foo/mumble");
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withEnvironment(env).run();
        Assert.assertTrue((boolean)result2.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result2.libPath);
        Assert.assertEquals((long)2L, (long)result2.libPath.length);
        Assert.assertEquals((Object)"/foo/bar", (Object)result2.libPath[0]);
        Assert.assertEquals((Object)"/foo/mumble", (Object)result2.libPath[1]);
        env = new HashMap();
        env.put("DRILL_JAVA_LIB_PATH", "/foo/bar:/foo/mumble");
        env.put("DOY_JAVA_LIB_PATH", "/doy/bar:/doy/mumble");
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withEnvironment(env).run();
        Assert.assertTrue((boolean)result2.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result2.libPath);
        Assert.assertEquals((long)4L, (long)result2.libPath.length);
        Assert.assertEquals((Object)"/doy/bar", (Object)result2.libPath[0]);
        Assert.assertEquals((Object)"/doy/mumble", (Object)result2.libPath[1]);
        Assert.assertEquals((Object)"/foo/bar", (Object)result2.libPath[2]);
        Assert.assertEquals((Object)"/foo/mumble", (Object)result2.libPath[3]);
        siteDir = new File(TestScripts.context.testDir, "site");
        context.createMockConf(siteDir);
        File libDir = new File(siteDir, "lib");
        context.createDir(libDir);
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).run();
        Assert.assertTrue((boolean)result2.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result2.libPath);
        Assert.assertEquals((long)1L, (long)result2.libPath.length);
        Assert.assertEquals((Object)libDir.getAbsolutePath(), (Object)result2.libPath[0]);
        HashMap<String, String> env2 = new HashMap<String, String>();
        env2.put("DRILL_JAVA_LIB_PATH", "/foo/bar:/foo/mumble");
        env2.put("DOY_JAVA_LIB_PATH", "/doy/bar:/doy/mumble");
        ScriptUtils.RunResult result3 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RUN).withSite(siteDir).withEnvironment(env2).run();
        Assert.assertTrue((boolean)result3.containsArgRegex(prefix + ".*"));
        Assert.assertNotNull((Object)result3.libPath);
        Assert.assertEquals((long)5L, (long)result3.libPath.length);
        Assert.assertEquals((Object)libDir.getAbsolutePath(), (Object)result3.libPath[0]);
        Assert.assertEquals((Object)"/doy/bar", (Object)result3.libPath[1]);
        Assert.assertEquals((Object)"/doy/mumble", (Object)result3.libPath[2]);
        Assert.assertEquals((Object)"/foo/bar", (Object)result3.libPath[3]);
        Assert.assertEquals((Object)"/foo/mumble", (Object)result3.libPath[4]);
    }

    @Test
    public void testStockDaemon() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START).start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateStockArgs();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result.stdout.contains("Starting drillbit, logging"));
        Assert.assertTrue((boolean)result.log.contains("Starting drillbit on"));
        Assert.assertTrue((boolean)result.log.contains("Drill Log Message"));
        Assert.assertTrue((boolean)result.out.contains("Drill Stdout Message"));
        Assert.assertTrue((boolean)result.out.contains("Stderr Message"));
        File pidFile = result.pidFile;
        Assert.assertTrue((boolean)pidFile.exists());
        File saveDir = new File(TestScripts.context.testDir, "save");
        context.createDir(saveDir);
        File savedPidFile = new File(saveDir, pidFile.getName());
        context.copyFile(pidFile, savedPidFile);
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("drillbit is running"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START).start();
        Assert.assertEquals((long)1L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("drillbit is already running as process"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STOP).run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.log.contains("Terminating drillbit pid"));
        Assert.assertTrue((boolean)result2.stdout.contains("Stopping drillbit"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).run();
        Assert.assertEquals((long)1L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("drillbit is not running"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STOP).run();
        Assert.assertEquals((long)1L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("No drillbit to stop because no pid file"));
        context.copyFile(savedPidFile, pidFile);
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).run();
        Assert.assertEquals((long)1L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("file is present but drillbit is not running"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STOP).run();
        Assert.assertEquals((long)1L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("No drillbit to stop because kill -0 of pid"));
    }

    @Test
    public void testStockDaemonWithArg() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        String propArg = "-Dproperty=value";
        ScriptUtils.DrillbitRun runner = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START);
        runner.withArg(propArg);
        ScriptUtils.RunResult result = runner.start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArg(propArg);
        this.validateAndCloseDaemon(null);
    }

    private void validateAndCloseDaemon(File siteDir) throws IOException {
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).withSite(siteDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.stdout.contains("drillbit is running"));
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STOP).withSite(siteDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
    }

    @Test
    public void testPidDir() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File pidDir = context.createDir(new File(TestScripts.context.testDir, "pid"));
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_PID_DIR", pidDir.getAbsolutePath());
        context.createEnvFile(new File(siteDir, "drill-env.sh"), drillEnv, false);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START).withPidDir(pidDir).start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.pidFile.getParentFile().equals(pidDir));
        Assert.assertTrue((boolean)result.pidFile.exists());
        this.validateAndCloseDaemon(null);
    }

    @Test
    public void testSiteDirWithDaemon() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDir, "site");
        context.createMockConf(siteDir);
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "9G");
        context.createEnvFile(new File(siteDir, "drill-env.sh"), drillEnv, false);
        ScriptUtils.DrillbitRun runner = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START);
        runner.withSite(siteDir);
        ScriptUtils.RunResult result = runner.start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArg("-XX:MaxDirectMemorySize=9G");
        this.validateAndCloseDaemon(siteDir);
        runner = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START);
        runner.addEnv("DRILL_CONF_DIR", siteDir.getAbsolutePath());
        result = runner.start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateArg("-XX:MaxDirectMemorySize=9G");
        this.validateAndCloseDaemon(siteDir);
    }

    @Test
    public void testLogDirWithDaemon() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File logsDir = context.createDir(new File(TestScripts.context.testDir, "logs"));
        context.removeDir(new File(TestScripts.context.testDrillHome, "log"));
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_LOG_DIR", logsDir.getAbsolutePath());
        context.createEnvFile(new File(siteDir, "drill-env.sh"), drillEnv, false);
        ScriptUtils.DrillbitRun runner = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START);
        runner.withLogDir(logsDir);
        ScriptUtils.RunResult result = runner.start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertNotNull((Object)result.logFile);
        Assert.assertTrue((boolean)result.logFile.getParentFile().equals(logsDir));
        Assert.assertTrue((boolean)result.logFile.exists());
        Assert.assertNotNull((Object)result.outFile);
        Assert.assertTrue((boolean)result.outFile.getParentFile().equals(logsDir));
        Assert.assertTrue((boolean)result.outFile.exists());
        this.validateAndCloseDaemon(null);
    }

    @Test
    public void testDrillbitSymlink() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        File drillbitFile = new File(TestScripts.context.testDrillHome, "bin/drillbit.sh");
        File linksDir = context.createDir(new File(TestScripts.context.testDir, "links"));
        File link = new File(linksDir, drillbitFile.getName());
        try {
            Files.createSymbolicLink(link.toPath(), drillbitFile.toPath(), new FileAttribute[0]);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START).start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertEquals((Object)result.pidFile.getParentFile(), (Object)TestScripts.context.testDrillHome);
        this.validateAndCloseDaemon(null);
    }

    @Test
    public void testRestart() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START).start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        int firstPid = result.getPid();
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).withSite(siteDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.stdout.contains("drillbit is running"));
        result = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_RESTART).start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        int secondPid = result.getPid();
        Assert.assertNotEquals((long)firstPid, (long)secondPid);
        this.validateAndCloseDaemon(null);
    }

    @Test
    public void testForcedKill() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.DrillbitRun runner = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_START);
        runner.addEnv("PRETEND_HUNG", "1");
        ScriptUtils.RunResult result = runner.start();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        ScriptUtils.RunResult result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STATUS).preserveLogs().run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("drillbit is running"));
        result2 = new ScriptUtils.DrillbitRun(ScriptUtils.DrillbitRun.DRILLBIT_STOP).addEnv("DRILL_STOP_TIMEOUT", "5").preserveLogs().run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        Assert.assertTrue((boolean)result2.stdout.contains("drillbit did not complete after"));
    }

    @Test
    public void testSqlline() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.ScriptRunner("sqlline").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result.containsArgsRegex(ScriptUtils.sqlLineArgs));
        int stockArgCount = result.echoArgs.size();
        result = new ScriptUtils.ScriptRunner("sqlline").withArg("arg1").withArg("arg2").run();
        Assert.assertTrue((boolean)result.containsArg("arg1"));
        Assert.assertTrue((boolean)result.containsArg("arg2"));
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("DRILL_JAVA_OPTS", "-Dprop=value");
        drillEnv.put("DRILL_HEAP", "5G");
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "7G");
        drillEnv.put("SERVER_LOG_GC", "1");
        drillEnv.put("DRILLBIT_CODE_CACHE_SIZE", "2G");
        ScriptUtils.RunResult result2 = new ScriptUtils.ScriptRunner("sqlline").withEnvironment(drillEnv).run();
        Assert.assertTrue((boolean)result2.containsArgsRegex(ScriptUtils.sqlLineArgs));
        Assert.assertEquals((long)stockArgCount, (long)result2.echoArgs.size());
        HashMap<String, String> shellEnv = new HashMap<String, String>();
        shellEnv.put("CLIENT_GC_OPTS", "-XX:+UseG1GC");
        result2 = new ScriptUtils.ScriptRunner("sqlline").withEnvironment(shellEnv).run();
        Assert.assertTrue((boolean)result2.containsArg("-XX:+UseG1GC"));
        drillEnv = new HashMap();
        drillEnv.put("DRILL_JAVA_OPTS", "-Dprop=value");
        drillEnv.put("DRILL_HEAP", "5G");
        drillEnv.put("DRILL_MAX_DIRECT_MEMORY", "7G");
        drillEnv.put("SERVER_LOG_GC", "1");
        drillEnv.put("DRILLBIT_CODE_CACHE_SIZE", "2G");
        drillEnv.put("DRILL_EMBEDDED", "1");
        result2 = new ScriptUtils.ScriptRunner("sqlline").withEnvironment(drillEnv).run();
        String[] expectedArgs = new String[]{"-Dprop=value", "-Xms5G", "-Xmx5G", "-XX:MaxDirectMemorySize=7G", "-XX:ReservedCodeCacheSize=2G"};
        result2.validateArgs(expectedArgs);
        Assert.assertTrue((boolean)result2.containsArg("sqlline.SqlLine"));
    }

    @Test
    public void testSqllineWithDrillbitContextEnv() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("DRILLBIT_CONTEXT", "0");
        HashMap<String, String> drillEnv = new HashMap<String, String>();
        drillEnv.put("SQLLINE_JAVA_OPTS", "-XX:MaxPermSize=256M");
        context.createEnvFileWithCondition(new File(siteDir, "distrib-env.sh"), conditions, drillEnv, true);
        String[] expectedArgs = new String[]{"-XX:MaxPermSize=256M"};
        ScriptUtils.RunResult result = new ScriptUtils.ScriptRunner("sqlline").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertFalse((boolean)result.containsArgsRegex(expectedArgs));
        conditions = new HashMap();
        conditions.put("DRILLBIT_CONTEXT", "1");
        drillEnv = new HashMap();
        drillEnv.put("SQLLINE_JAVA_OPTS", "-XX:MaxPermSize=256M");
        expectedArgs = new String[]{"-XX:MaxPermSize=256M"};
        context.createEnvFileWithCondition(new File(siteDir, "distrib-env.sh"), conditions, drillEnv, true);
        result = new ScriptUtils.ScriptRunner("sqlline").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertFalse((boolean)result.containsArgsRegex(expectedArgs));
        HashMap<String, String> drillEnv2 = new HashMap<String, String>();
        drillEnv2.put("SQLLINE_JAVA_OPTS", "-XX:MaxPermSize=256M");
        String[] expectedArgs2 = new String[]{"-XX:MaxPermSize=256M"};
        context.createEnvFile(new File(siteDir, "distrib-env.sh"), drillEnv2, true);
        ScriptUtils.RunResult result2 = new ScriptUtils.ScriptRunner("sqlline").run();
        Assert.assertEquals((long)0L, (long)result2.returnCode);
        result2.validateJava();
        result2.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result2.containsArgsRegex(expectedArgs2));
    }

    @Test
    public void testSqllineSiteDir() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDir, "site");
        context.createMockConf(siteDir);
        context.writeFile(new File(siteDir, "drill-env.sh"), "#!/bin/bash\n# Example file\nexport SQLLINE_JAVA_OPTS=\"-XX:MaxPermSize=256M\"\n");
        File siteJars = new File(siteDir, "jars");
        context.createDir(siteJars);
        context.makeDummyJar(siteJars, "site");
        ScriptUtils.RunResult result = new ScriptUtils.ScriptRunner("sqlline").withSite(siteDir).run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        Assert.assertTrue((boolean)result.containsArg("-XX:MaxPermSize=256M"));
        result.validateClassPath(siteJars.getAbsolutePath() + "/*");
    }

    @Test
    public void testSqllineWrappers() throws IOException {
        context.createMockDistrib();
        File siteDir = new File(TestScripts.context.testDrillHome, "conf");
        context.createMockConf(siteDir);
        ScriptUtils.RunResult result = new ScriptUtils.ScriptRunner("drill-conf").withArg("arg1").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result.containsArgsRegex(ScriptUtils.sqlLineArgs));
        Assert.assertTrue((boolean)result.containsArg("-u"));
        Assert.assertTrue((boolean)result.containsArg("jdbc:drill:"));
        Assert.assertTrue((boolean)result.containsArg("arg1"));
        result = new ScriptUtils.ScriptRunner("drill-localhost").withArg("arg1").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result.containsArgsRegex(ScriptUtils.sqlLineArgs));
        Assert.assertTrue((boolean)result.containsArg("-u"));
        Assert.assertTrue((boolean)result.containsArg("jdbc:drill:drillbit=localhost"));
        Assert.assertTrue((boolean)result.containsArg("arg1"));
        result = new ScriptUtils.ScriptRunner("drill-embedded").withArg("arg1").run();
        Assert.assertEquals((long)0L, (long)result.returnCode);
        result.validateJava();
        result.validateClassPath(ScriptUtils.stdCp);
        Assert.assertTrue((boolean)result.containsArgsRegex(ScriptUtils.sqlLineArgs));
        Assert.assertTrue((boolean)result.containsArg("-u"));
        Assert.assertTrue((boolean)result.containsArg("jdbc:drill:zk=local"));
        Assert.assertTrue((boolean)result.containsArg("-Xms4G"));
        Assert.assertTrue((boolean)result.containsArg("-XX:MaxDirectMemorySize=8G"));
        Assert.assertTrue((boolean)result.containsArg("arg1"));
    }
}

