/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.parser.LogicalExpressionParser;
import org.apache.drill.common.types.TypeProtos;

@JsonSerialize(using=Se.class)
public interface LogicalExpression
extends Iterable<LogicalExpression> {
    public TypeProtos.MajorType getMajorType();

    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> var1, V var2) throws E;

    public ExpressionPosition getPosition();

    public int getSelfCost();

    public int getCumulativeCost();

    public static class Se
    extends StdSerializer<LogicalExpression> {
        protected Se() {
            super(LogicalExpression.class);
        }

        public void serialize(LogicalExpression value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            StringBuilder sb = new StringBuilder();
            ExpressionStringBuilder esb = new ExpressionStringBuilder();
            value.accept(esb, sb);
            jgen.writeString(sb.toString());
        }
    }

    public static class De
    extends StdDeserializer<LogicalExpression> {
        DrillConfig config;

        public De(DrillConfig config) {
            super(LogicalExpression.class);
            this.config = config;
        }

        public LogicalExpression deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String expr = jp.getText();
            if (expr == null || expr.isEmpty()) {
                return null;
            }
            return LogicalExpressionParser.parse(expr);
        }
    }
}

