/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.AbstractSingleBuilder;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="project")
public class Project
extends SingleInputOperator {
    private final List<NamedExpression> selections;

    @JsonCreator
    public Project(@JsonProperty(value="projections") List<NamedExpression> selections) {
        this.selections = selections;
        if (selections == null || selections.size() == 0) {
            throw new ExpressionParsingException("Project did not provide any projection selections.  At least one projection must be provided.");
        }
    }

    @JsonProperty(value="projections")
    public List<NamedExpression> getSelections() {
        return this.selections;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitProject(this, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractSingleBuilder<Project, Builder> {
        private List<NamedExpression> exprs = Lists.newArrayList();

        public Builder addExpr(NamedExpression expr) {
            this.exprs.add(expr);
            return this;
        }

        public Builder addExpr(FieldReference ref, LogicalExpression expr) {
            this.exprs.add(new NamedExpression(expr, ref));
            return this;
        }

        @Override
        public Project internalBuild() {
            return new Project(this.exprs);
        }
    }
}

