/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.graph.AdjacencyList;
import org.apache.drill.common.graph.Edge;
import org.apache.drill.common.graph.Graph;
import org.apache.drill.common.graph.GraphValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphAlgos {
    static final Logger logger = LoggerFactory.getLogger(GraphAlgos.class);

    static <V extends GraphValue<V>> List<List<AdjacencyList.Node>> checkDirected(AdjacencyList<V> graph) {
        Tarjan<V> t = new Tarjan<V>();
        List<List<AdjacencyList.Node>> subgraphs = t.executeTarjan(graph);
        Iterator<List<AdjacencyList.Node>> i = subgraphs.iterator();
        while (i.hasNext()) {
            List<AdjacencyList.Node> l = i.next();
            if (l.size() != 1) continue;
            i.remove();
        }
        return subgraphs;
    }

    public static <V extends GraphValue<V>> List<List<AdjacencyList.Node>> checkDirected(Graph<V, ?, ?> graph) {
        return GraphAlgos.checkDirected(graph.getAdjList());
    }

    public static class Tarjan<V extends GraphValue<V>> {
        private int index = 0;
        private List<AdjacencyList.Node> stack = new LinkedList<AdjacencyList.Node>();
        private List<List<AdjacencyList.Node>> SCC = new LinkedList<List<AdjacencyList.Node>>();

        public List<List<AdjacencyList.Node>> executeTarjan(AdjacencyList<V> graph) {
            this.SCC.clear();
            this.index = 0;
            this.stack.clear();
            if (graph != null) {
                LinkedList<AdjacencyList.Node> nodeList = new LinkedList<AdjacencyList.Node>(graph.getNodeSet());
                for (AdjacencyList.Node node : nodeList) {
                    if (node.index != -1) continue;
                    this.tarjan(node, graph);
                }
            }
            return this.SCC;
        }

        private List<List<AdjacencyList.Node>> tarjan(AdjacencyList.Node v, AdjacencyList<V> list) {
            v.index = this.index;
            v.lowlink = this.index++;
            this.stack.add(0, v);
            List<Edge<AdjacencyList.Node>> l = list.getAdjacent(v);
            if (l != null) {
                for (Edge<AdjacencyList.Node> e : l) {
                    AdjacencyList.Node n = (AdjacencyList.Node)e.to;
                    if (n.index == -1) {
                        this.tarjan(n, list);
                        v.lowlink = Math.min(v.lowlink, n.lowlink);
                        continue;
                    }
                    if (!this.stack.contains(n)) continue;
                    v.lowlink = Math.min(v.lowlink, n.index);
                }
            }
            if (v.lowlink == v.index) {
                AdjacencyList.Node n;
                LinkedList<AdjacencyList.Node> component = new LinkedList<AdjacencyList.Node>();
                do {
                    n = this.stack.remove(0);
                    component.add(n);
                } while (n != v);
                this.SCC.add(component);
            }
            return this.SCC;
        }
    }

    public static class TopoSorter<V extends GraphValue<V>> {
        final List<AdjacencyList.Node> sorted = new LinkedList<AdjacencyList.Node>();
        final AdjacencyList<V> rGraph;

        private TopoSorter(AdjacencyList<V> graph, boolean reverse) {
            graph.clearVisited();
            this.rGraph = reverse ? graph.getReversedList() : graph;
            Collection<AdjacencyList.Node> sourceNodes = this.rGraph.getInternalRootNodes();
            for (AdjacencyList.Node n : sourceNodes) {
                this.visit(n);
            }
        }

        private void visit(AdjacencyList.Node n) {
            if (n.visited) {
                return;
            }
            n.visited = true;
            List<Edge<AdjacencyList.Node>> edges = this.rGraph.getAdjacent(n);
            if (edges != null) {
                for (Edge<AdjacencyList.Node> e : edges) {
                    this.visit((AdjacencyList.Node)e.to);
                }
            }
            this.sorted.add(n);
        }

        static <V extends GraphValue<V>> List<AdjacencyList.Node> sortInternal(AdjacencyList<V> graph, boolean reverse) {
            TopoSorter<V> ts = new TopoSorter<V>(graph, reverse);
            return ts.sorted;
        }

        public static <V extends GraphValue<V>> List<V> sort(Graph<V, ?, ?> graph) {
            AdjacencyList<V> l = graph.getAdjList();
            return l.convert(TopoSorter.sortInternal(l, true));
        }

        public static <V extends GraphValue<V>> List<V> sortLogical(Graph<V, ?, ?> graph) {
            AdjacencyList<V> l = graph.getAdjList();
            return l.convert(TopoSorter.sortInternal(l, false));
        }
    }
}

