/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.logical.data.AbstractBuilder;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="union")
public class Union
extends LogicalOperatorBase {
    private final List<LogicalOperator> inputs;
    private final boolean distinct;

    @JsonCreator
    public Union(@JsonProperty(value="inputs") List<LogicalOperator> inputs, @JsonProperty(value="distinct") Boolean distinct) {
        this.inputs = inputs;
        for (LogicalOperator o : inputs) {
            o.registerAsSubscriber(this);
        }
        this.distinct = distinct == null ? false : distinct;
    }

    public List<LogicalOperator> getInputs() {
        return this.inputs;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitUnion(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return this.inputs.iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Union> {
        private List<LogicalOperator> inputs = Lists.newArrayList();
        private boolean distinct;

        public Builder addInput(LogicalOperator o) {
            this.inputs.add(o);
            return this;
        }

        public Builder setDistinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        @Override
        public Union build() {
            return new Union(this.inputs, this.distinct);
        }
    }
}

