/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.data.AbstractBuilder;
import org.apache.drill.common.logical.data.SourceOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="values")
public class Values
extends SourceOperator {
    private final JSONOptions content;

    @JsonCreator
    public Values(@JsonProperty(value="content") JSONOptions content) {
        this.content = content;
        Preconditions.checkNotNull((Object)content, (Object)"content attribute is required for source operator 'constant'.");
    }

    public JSONOptions getContent() {
        return this.content;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitValues(this, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractBuilder<Values> {
        private JSONOptions content;

        public Builder content(JsonNode n) {
            this.content = new JSONOptions(n, JsonLocation.NA);
            return this;
        }

        @Override
        public Values build() {
            return new Values(this.content);
        }
    }
}

