/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
public class FieldReference
extends SchemaPath {
    private TypeProtos.MajorType overrideType;

    public FieldReference(SchemaPath sp) {
        super(sp);
        this.checkData();
    }

    private void checkData() {
        if (this.getRootSegment().getChild() != null) {
            throw new UnsupportedOperationException("Field references must be singular names.");
        }
    }

    public FieldReference(CharSequence value) {
        this(value, ExpressionPosition.UNKNOWN);
    }

    public static FieldReference getWithQuotedRef(CharSequence safeString) {
        return new FieldReference(safeString, ExpressionPosition.UNKNOWN, false);
    }

    public FieldReference(CharSequence value, ExpressionPosition pos) {
        this(value, pos, true);
    }

    public FieldReference(CharSequence value, ExpressionPosition pos, boolean check) {
        super(new PathSegment.NameSegment(value), pos);
        if (check) {
            this.checkData();
        }
    }

    public FieldReference(String value, ExpressionPosition pos, TypeProtos.MajorType dataType) {
        this((CharSequence)value, pos);
        this.overrideType = dataType;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        if (this.overrideType == null) {
            return super.getMajorType();
        }
        return this.overrideType;
    }

    public static class Se
    extends StdSerializer<FieldReference> {
        public Se() {
            super(FieldReference.class);
        }

        public void serialize(FieldReference value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeString('`' + value.getRootSegment().getNameSegment().getPath() + '`');
        }
    }

    public static class De
    extends StdDeserializer<FieldReference> {
        public De() {
            super(FieldReference.class);
        }

        public FieldReference deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String ref = this._parseString(jp, ctxt);
            ref = ref.replace("`", "");
            return new FieldReference((CharSequence)ref, ExpressionPosition.UNKNOWN, true);
        }
    }
}

