/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression.parser;

import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.parser.LogicalExpressionParser;
import org.apache.drill.test.DrillTest;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TreeTest
extends DrillTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void escapeStringLiteral() {
        String expr = "func(`identifier`, '\\\\d+', 0, 'fjds')";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    public void escapeQuotedIdentifier() {
        String expr = "`a\\\\b` + `c'd`";
        this.testExpressionParsing(expr, "add(`a\\\\b`, `c'd`)");
    }

    @Test
    public void testIfWithCase() {
        this.testExpressionParsing("if ($F1) then case when (_MAP.R_NAME = 'AFRICA') then 2 else 4 end else if(4==3) then 1 else if(x==3) then 7 else (if(2==1) then 6 else 4 end) end", "( if (equal(`x`, 3)  ) then (7 )  else ( ( if (equal(2, 1)  ) then (6 )  else (4 )  end  )  )  end  )");
    }

    @Test
    public void testAdd() {
        this.testExpressionParsing("2+2", "add(2, 2)");
    }

    @Test
    public void testIf() {
        this.testExpressionParsing("if ('blue.red') then 'orange' else if (false) then 1 else 0 end", "( if (false ) then (1 )  else (0 )  end  )");
    }

    @Test
    public void testQuotedIdentifier() {
        String expr = "`hello friend`.`goodbye`";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    public void testSpecialQuoted() {
        this.testExpressionParsing("`*0` + `*` ", "add(`*0`, `*`)");
    }

    @Test
    public void testQuotedIdentifier2() {
        this.testExpressionParsing("`hello friend`.goodbye", "`hello friend`.`goodbye`");
    }

    @Test
    public void testComplexIdentifier() {
        this.testExpressionParsing("goodbye[4].`hello`", "`goodbye`[4].`hello`");
    }

    @Test
    public void testCastToBooleanExpr() {
        String expr = "cast( (cast( (`bool_col` ) as VARCHAR(100) ) ) as BIT )";
        this.testExpressionParsing(expr, expr);
    }

    @Test
    public void testComments() {
        this.testExpressionParsing("cast /* block comment */ ( // single comment\n1 as int)", "cast( (1 ) as INT )");
    }

    @Test
    public void testParsingException() {
        this.thrown.expect(ExpressionParsingException.class);
        this.thrown.expectMessage(CoreMatchers.containsString((String)"mismatched input 'i' expecting"));
        this.testExpressionParsing("cast(1 as i)", "");
    }

    @Test
    public void testFunctionCallWithoutParams() {
        String expr = "now()";
        this.testExpressionParsing(expr, expr);
    }

    private void testExpressionParsing(String expr, String expected) {
        LogicalExpression e1 = LogicalExpressionParser.parse((String)expr);
        String newStringExpr = this.serializeExpression(e1);
        Assert.assertEquals((Object)expected, (Object)newStringExpr.trim());
        LogicalExpressionParser.parse((String)newStringExpr);
    }

    private String serializeExpression(LogicalExpression expr) {
        ExpressionStringBuilder b = new ExpressionStringBuilder();
        StringBuilder sb = new StringBuilder();
        expr.accept((ExprVisitor)b, (Object)sb);
        return sb.toString();
    }
}

