/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import org.apache.drill.common.expression.SchemaPath;
import org.junit.Assert;
import org.junit.Test;

public class SchemaPathTest {
    @Test
    public void testUnIndexedWithOutArray() {
        SchemaPath oneElementSchema = SchemaPath.parseFromString((String)"`a`");
        Assert.assertEquals((String)"Schema path should match", (Object)oneElementSchema, (Object)oneElementSchema.getUnIndexed());
        SchemaPath severalElementsSchema = SchemaPath.parseFromString((String)"`a`.`b`.`c`");
        Assert.assertEquals((String)"Schema path should match", (Object)severalElementsSchema, (Object)severalElementsSchema.getUnIndexed());
    }

    @Test
    public void testUnIndexedEndingWithArray() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0]");
        Assert.assertEquals((String)"Schema path should match", (Object)SchemaPath.parseFromString((String)"`a`.`b`"), (Object)schemaPath.getUnIndexed());
    }

    @Test
    public void testUnIndexedArrayInTheMiddle() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0].`c`.`d`");
        Assert.assertEquals((String)"Schema path should match", (Object)SchemaPath.parseFromString((String)"`a`.`b`.`c`.`d`"), (Object)schemaPath.getUnIndexed());
    }

    @Test
    public void testUnIndexedMultipleArrays() {
        SchemaPath schemaPath = SchemaPath.parseFromString((String)"`a`.`b`[0][1].`c`.`d`[2][0]");
        Assert.assertEquals((String)"Schema path should match", (Object)SchemaPath.parseFromString((String)"`a`.`b`.`c`.`d`"), (Object)schemaPath.getUnIndexed());
    }

    @Test
    public void testCompoundPathN() {
        SchemaPath schemaPath = SchemaPath.getCompoundPath((int)3, (String[])new String[]{"a", "b", "c", "d", "e"});
        Assert.assertEquals((String)"Schema path should match", (Object)SchemaPath.getCompoundPath((String[])new String[]{"a", "b", "c"}), (Object)schemaPath);
    }
}

