/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.exceptions;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.proto.UserBitShared;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUserException {
    private static final Logger logger = LoggerFactory.getLogger((String)"--ignore.as.this.is.for.testing.exceptions--");

    private Exception wrap(UserException uex, int numWraps) {
        Object ex = uex;
        for (int i = 0; i < numWraps; ++i) {
            ex = new Exception("wrap #" + (i + 1), (Throwable)ex);
        }
        return ex;
    }

    @Test
    public void testBuildSystemException() {
        String message = "This is an exception";
        UserException uex = UserException.systemError((Throwable)new Exception(new RuntimeException(message))).build(logger);
        Assert.assertTrue((boolean)uex.getOriginalMessage().contains(message));
        Assert.assertTrue((boolean)uex.getOriginalMessage().contains("RuntimeException"));
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(true);
        Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.SYSTEM, (Object)error.getErrorType());
    }

    @Test
    public void testBuildUserExceptionWithMessage() {
        String message = "Test message";
        UserException uex = UserException.dataWriteError().message(message, new Object[0]).build(logger);
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
        Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.DATA_WRITE, (Object)error.getErrorType());
        Assert.assertEquals((Object)message, (Object)uex.getOriginalMessage());
    }

    @Test
    public void testBuildUserExceptionWithCause() {
        String message = "Test message";
        UserException uex = UserException.dataWriteError((Throwable)new RuntimeException(message)).build(logger);
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
        Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.DATA_WRITE, (Object)error.getErrorType());
        Assert.assertEquals((Object)message, (Object)uex.getOriginalMessage());
    }

    @Test
    public void testBuildUserExceptionWithCauseAndMessage() {
        String messageA = "Test message A";
        String messageB = "Test message B";
        UserException uex = UserException.dataWriteError((Throwable)new RuntimeException(messageA)).message(messageB, new Object[0]).build(logger);
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
        Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.DATA_WRITE, (Object)error.getErrorType());
        Assert.assertFalse((boolean)error.getMessage().contains(messageA));
        Assert.assertEquals((Object)messageB, (Object)uex.getOriginalMessage());
    }

    @Test
    public void testBuildUserExceptionWithUserExceptionCauseAndMessage() {
        String messageA = "Test message A";
        String messageB = "Test message B";
        UserException original = UserException.connectionError().message(messageA, new Object[0]).build(logger);
        UserException uex = UserException.dataWriteError((Throwable)this.wrap(original, 5)).message(messageB, new Object[0]).build(logger);
        Assert.assertEquals((Object)original, (Object)uex);
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
        Assert.assertEquals((Object)messageA, (Object)uex.getOriginalMessage());
        Assert.assertFalse((boolean)error.getMessage().contains(messageB));
    }

    @Test
    public void testBuildUserExceptionWithFormattedMessage() {
        String format = "This is test #%d";
        UserException uex = UserException.connectionError().message(format, new Object[]{5}).build(logger);
        UserBitShared.DrillPBError error = uex.getOrCreatePBError(false);
        Assert.assertEquals((Object)UserBitShared.DrillPBError.ErrorType.CONNECTION, (Object)error.getErrorType());
        Assert.assertEquals((Object)String.format(format, 5), (Object)uex.getOriginalMessage());
    }

    @Test
    public void testWrapUserException() {
        UserException uex = UserException.dataReadError().message("this is a data read exception", new Object[0]).build(logger);
        Exception wrapped = this.wrap(uex, 3);
        Assert.assertEquals((Object)uex, (Object)UserException.systemError((Throwable)wrapped).build(logger));
    }
}

