/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.spark.client.SparkClient;
import org.apache.hive.spark.client.SparkClientImpl;
import org.apache.hive.spark.client.rpc.RpcServer;
import org.apache.spark.SparkException;

@InterfaceAudience.Private
public final class SparkClientFactory {
    static final String CONF_KEY_IN_PROCESS = "spark.client.do_not_use.run_driver_in_process";
    static final String CONF_CLIENT_ID = "spark.client.authentication.client_id";
    static final String CONF_KEY_SECRET = "spark.client.authentication.secret";
    private static RpcServer server = null;

    public static synchronized void initialize(Map<String, String> conf) throws IOException {
        if (server == null) {
            try {
                server = new RpcServer(conf);
            }
            catch (InterruptedException ie) {
                throw Throwables.propagate(ie);
            }
        }
    }

    public static synchronized void stop() {
        if (server != null) {
            server.close();
            server = null;
        }
    }

    public static synchronized SparkClient createClient(Map<String, String> sparkConf, HiveConf hiveConf) throws IOException, SparkException {
        Preconditions.checkState(server != null, "initialize() not called.");
        return new SparkClientImpl(server, sparkConf, hiveConf);
    }
}

