/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.Maps;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.sql.SqlFunction;
import hive.org.apache.calcite.sql.SqlFunctionCategory;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.type.InferTypes;
import hive.org.apache.calcite.sql.type.OperandTypes;
import hive.org.apache.calcite.sql.type.ReturnTypes;
import hive.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import hive.org.apache.calcite.sql.type.SqlOperandTypeInference;
import hive.org.apache.calcite.sql.type.SqlReturnTypeInference;
import hive.org.apache.calcite.sql.type.SqlTypeFamily;
import hive.org.apache.calcite.util.Util;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class SqlFunctionConverter {
    private static final Log LOG = LogFactory.getLog(SqlFunctionConverter.class);
    static final Map<String, SqlOperator> hiveToCalcite;
    static final Map<SqlOperator, HiveToken> calciteToHiveToken;
    static final Map<SqlOperator, String> reverseOperatorMap;

    public static SqlOperator getCalciteOperator(String funcTextName, GenericUDF hiveUDF, ImmutableList<RelDataType> calciteArgTypes, RelDataType retType) throws SemanticException {
        if (hiveUDF instanceof GenericUDFOPNegative) {
            return SqlStdOperatorTable.UNARY_MINUS;
        }
        if (hiveUDF instanceof GenericUDFOPPositive) {
            return SqlStdOperatorTable.UNARY_PLUS;
        }
        String name = null;
        if (StringUtils.isEmpty(funcTextName)) {
            name = SqlFunctionConverter.getName(hiveUDF);
            LOG.warn((Object)("The function text was empty, name from annotation is " + name));
        } else {
            name = FunctionRegistry.getNormalizedFunctionName(funcTextName);
        }
        return SqlFunctionConverter.getCalciteFn(name, calciteArgTypes, retType, FunctionRegistry.isDeterministic(hiveUDF));
    }

    public static GenericUDF getHiveUDF(SqlOperator op, RelDataType dt, int argsLength) {
        FunctionInfo hFn;
        String name = reverseOperatorMap.get(op);
        if (name == null) {
            name = op.getName();
        }
        if (argsLength == 1) {
            if (name == "+") {
                name = "positive";
            } else if (name == "-") {
                name = "negative";
            }
        }
        try {
            hFn = name != null ? FunctionRegistry.getFunctionInfo(name) : null;
        }
        catch (SemanticException e) {
            LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
            hFn = null;
        }
        if (hFn == null) {
            try {
                hFn = SqlFunctionConverter.handleExplicitCast(op, dt);
            }
            catch (SemanticException e) {
                LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
                hFn = null;
            }
        }
        return hFn == null ? null : hFn.getGenericUDF();
    }

    private static FunctionInfo handleExplicitCast(SqlOperator op, RelDataType dt) throws SemanticException {
        FunctionInfo castUDF = null;
        if (op.kind == SqlKind.CAST) {
            TypeInfo castType = TypeConverter.convert(dt);
            if (castType.equals(TypeInfoFactory.byteTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("tinyint");
            } else if (castType instanceof CharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("char"));
            } else if (castType instanceof VarcharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("varchar"));
            } else if (castType.equals(TypeInfoFactory.stringTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("string");
            } else if (castType.equals(TypeInfoFactory.booleanTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("boolean");
            } else if (castType.equals(TypeInfoFactory.shortTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("smallint");
            } else if (castType.equals(TypeInfoFactory.intTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("int");
            } else if (castType.equals(TypeInfoFactory.longTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("bigint");
            } else if (castType.equals(TypeInfoFactory.floatTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("float");
            } else if (castType.equals(TypeInfoFactory.doubleTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("double");
            } else if (castType.equals(TypeInfoFactory.timestampTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("timestamp");
            } else if (castType.equals(TypeInfoFactory.dateTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("date");
            } else if (castType instanceof DecimalTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("decimal"));
            } else if (castType.equals(TypeInfoFactory.binaryTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("binary");
            } else {
                throw new IllegalStateException("Unexpected type : " + castType.getQualifiedName());
            }
        }
        return castUDF;
    }

    private static FunctionInfo handleCastForParameterizedType(TypeInfo ti, FunctionInfo fi) {
        SettableUDF udf = (SettableUDF)((Object)fi.getGenericUDF());
        try {
            udf.setTypeInfo(ti);
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
        return new FunctionInfo(fi.isNative(), fi.getDisplayName(), (GenericUDF)((Object)udf), fi.getResources());
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children) {
        ASTNode node;
        HiveToken hToken = calciteToHiveToken.get(op);
        if (hToken != null) {
            node = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
        } else {
            node = (ASTNode)ParseDriver.adaptor.create(705, "TOK_FUNCTION");
            if (op.kind != SqlKind.CAST) {
                if (op.kind == SqlKind.MINUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(299, "MINUS");
                } else if (op.kind == SqlKind.PLUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(303, "PLUS");
                } else {
                    if (op.getName().toUpperCase().equals(SqlStdOperatorTable.COUNT.getName()) && children.size() == 0) {
                        node = (ASTNode)ParseDriver.adaptor.create(707, "TOK_FUNCTIONSTAR");
                    }
                    node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(26, op.getName())));
                }
            }
        }
        for (ASTNode c : children) {
            ParseDriver.adaptor.addChild((Object)node, (Object)c);
        }
        return node;
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children, int i) {
        if (i + 1 < children.size()) {
            HiveToken hToken = calciteToHiveToken.get(op);
            ASTNode curNode = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
            ParseDriver.adaptor.addChild((Object)curNode, (Object)children.get(i));
            ParseDriver.adaptor.addChild((Object)curNode, (Object)SqlFunctionConverter.buildAST(op, children, i + 1));
            return curNode;
        }
        return children.get(i);
    }

    private static String getName(GenericUDF hiveUDF) {
        String udfName = null;
        if (hiveUDF instanceof GenericUDFBridge) {
            udfName = ((GenericUDFBridge)hiveUDF).getUdfName();
        } else {
            int indx;
            String[] aliases;
            Description udfDescription;
            Class<?> udfClass = hiveUDF.getClass();
            Description udfAnnotation = udfClass.getAnnotation(Description.class);
            if (udfAnnotation != null && udfAnnotation instanceof Description && (udfName = (udfDescription = udfAnnotation).name()) != null && (aliases = udfName.split(",")).length > 0) {
                udfName = aliases[0];
            }
            if ((udfName == null || udfName.isEmpty()) && (indx = (udfName = hiveUDF.getClass().getName()).lastIndexOf(".")) >= 0) {
                udfName = udfName.substring(++indx);
            }
        }
        return udfName;
    }

    private static HiveToken hToken(int type, String text) {
        return new HiveToken(type, text, new String[0]);
    }

    private static CalciteUDFInfo getUDFInfo(String hiveUdfName, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        CalciteUDFInfo udfInfo = new CalciteUDFInfo();
        udfInfo.udfName = hiveUdfName;
        udfInfo.returnTypeInference = ReturnTypes.explicit(calciteRetType);
        udfInfo.operandTypeInference = InferTypes.explicit(calciteArgTypes);
        ImmutableList.Builder typeFamilyBuilder = new ImmutableList.Builder();
        for (RelDataType at : calciteArgTypes) {
            typeFamilyBuilder.add(Util.first(at.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        udfInfo.operandTypeChecker = OperandTypes.family((List<SqlTypeFamily>)((Object)typeFamilyBuilder.build()));
        udfInfo.argTypes = ImmutableList.copyOf(calciteArgTypes);
        udfInfo.retType = calciteRetType;
        return udfInfo;
    }

    public static SqlOperator getCalciteFn(String hiveUdfName, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType, boolean deterministic) throws CalciteSemanticException {
        if (hiveUdfName != null && hiveUdfName.trim().equals("<=>")) {
            throw new CalciteSemanticException("<=> is not yet supported for cbo.", CalciteSemanticException.UnsupportedFeature.Less_than_equal_greater_than);
        }
        SqlOperator calciteOp = hiveToCalcite.get(hiveUdfName);
        if (calciteOp == null) {
            CalciteUDFInfo uInf = SqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
            calciteOp = new CalciteSqlFn(uInf.udfName, SqlKind.OTHER_FUNCTION, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, deterministic);
        }
        return calciteOp;
    }

    public static SqlAggFunction getCalciteAggFn(String hiveUdfName, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        SqlAggFunction calciteAggFn = (SqlAggFunction)hiveToCalcite.get(hiveUdfName);
        if (calciteAggFn == null) {
            CalciteUDFInfo uInf = SqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
            calciteAggFn = new CalciteUDAF(uInf.udfName, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, uInf.argTypes, uInf.retType);
        }
        return calciteAggFn;
    }

    static {
        StaticBlockBuilder builder = new StaticBlockBuilder();
        hiveToCalcite = ImmutableMap.copyOf(builder.hiveToCalcite);
        calciteToHiveToken = ImmutableMap.copyOf(builder.calciteToHiveToken);
        reverseOperatorMap = ImmutableMap.copyOf(builder.reverseOperatorMap);
    }

    static class HiveToken {
        int type;
        String text;
        String[] args;

        HiveToken(int type, String text, String ... args) {
            this.type = type;
            this.text = text;
            this.args = args;
        }
    }

    private static class CalciteUDFInfo {
        private String udfName;
        private SqlReturnTypeInference returnTypeInference;
        private SqlOperandTypeInference operandTypeInference;
        private SqlOperandTypeChecker operandTypeChecker;
        private ImmutableList<RelDataType> argTypes;
        private RelDataType retType;

        private CalciteUDFInfo() {
        }
    }

    private static class CalciteSqlFn
    extends SqlFunction {
        private final boolean deterministic;

        public CalciteSqlFn(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category, boolean deterministic) {
            super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
            this.deterministic = deterministic;
        }

        @Override
        public boolean isDeterministic() {
            return this.deterministic;
        }
    }

    public static class CalciteUDAF
    extends SqlAggFunction {
        public CalciteUDAF(String opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, ImmutableList<RelDataType> argTypes, RelDataType retType) {
            super(opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        }
    }

    private static class StaticBlockBuilder {
        final Map<String, SqlOperator> hiveToCalcite = Maps.newHashMap();
        final Map<SqlOperator, HiveToken> calciteToHiveToken = Maps.newHashMap();
        final Map<SqlOperator, String> reverseOperatorMap = Maps.newHashMap();

        StaticBlockBuilder() {
            this.registerFunction("+", SqlStdOperatorTable.PLUS, SqlFunctionConverter.hToken(303, "+"));
            this.registerFunction("-", SqlStdOperatorTable.MINUS, SqlFunctionConverter.hToken(299, "-"));
            this.registerFunction("*", SqlStdOperatorTable.MULTIPLY, SqlFunctionConverter.hToken(311, "*"));
            this.registerFunction("/", SqlStdOperatorTable.DIVIDE, SqlFunctionConverter.hToken(311, "/"));
            this.registerFunction("%", SqlStdOperatorTable.MOD, SqlFunctionConverter.hToken(311, "%"));
            this.registerFunction("and", SqlStdOperatorTable.AND, SqlFunctionConverter.hToken(33, "and"));
            this.registerFunction("or", SqlStdOperatorTable.OR, SqlFunctionConverter.hToken(182, "or"));
            this.registerFunction("=", SqlStdOperatorTable.EQUALS, SqlFunctionConverter.hToken(20, "="));
            this.registerFunction("<", SqlStdOperatorTable.LESS_THAN, SqlFunctionConverter.hToken(294, "<"));
            this.registerFunction("<=", SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlFunctionConverter.hToken(295, "<="));
            this.registerFunction(">", SqlStdOperatorTable.GREATER_THAN, SqlFunctionConverter.hToken(23, ">"));
            this.registerFunction(">=", SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlFunctionConverter.hToken(24, ">="));
            this.registerFunction("!", SqlStdOperatorTable.NOT, SqlFunctionConverter.hToken(175, "not"));
            this.registerFunction("<>", SqlStdOperatorTable.NOT_EQUALS, SqlFunctionConverter.hToken(301, "<>"));
        }

        private void registerFunction(String name, SqlOperator calciteFn, HiveToken hiveToken) {
            FunctionInfo hFn;
            this.reverseOperatorMap.put(calciteFn, name);
            try {
                hFn = FunctionRegistry.getFunctionInfo(name);
            }
            catch (SemanticException e) {
                LOG.warn((Object)("Failed to load udf " + name), (Throwable)e);
                hFn = null;
            }
            if (hFn != null) {
                String hFnName = SqlFunctionConverter.getName(hFn.getGenericUDF());
                this.hiveToCalcite.put(hFnName, calciteFn);
                if (hiveToken != null) {
                    this.calciteToHiveToken.put(calciteFn, hiveToken);
                }
            }
        }
    }
}

