/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdCollation;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;

public class HiveRelMdCollation {
    public static final RelMetadataProvider SOURCE = ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLLATIONS.method, new HiveRelMdCollation()), RelMdCollation.SOURCE));

    private HiveRelMdCollation() {
    }

    public ImmutableList<RelCollation> collations(HiveAggregate aggregate) {
        ImmutableList.Builder collationListBuilder = new ImmutableList.Builder();
        for (int pos : aggregate.getGroupSet().asList()) {
            RelFieldCollation fieldCollation = new RelFieldCollation(pos);
            collationListBuilder.add(fieldCollation);
        }
        return ImmutableList.of(RelCollationTraitDef.INSTANCE.canonize(new HiveRelCollation((ImmutableList<RelFieldCollation>)collationListBuilder.build())));
    }

    public ImmutableList<RelCollation> collations(HiveJoin join) {
        return join.getCollation();
    }
}

