/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.LinkedHashMultimap;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;

public class HivePreFilteringRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog((String)HivePreFilteringRule.class.getName());
    public static final HivePreFilteringRule INSTANCE = new HivePreFilteringRule();
    private final RelFactories.FilterFactory filterFactory = HiveFilter.DEFAULT_FILTER_FACTORY;
    private static final Set<String> COMPARISON_UDFS = Sets.newHashSet(GenericUDFOPEqual.class.getAnnotation(Description.class).name(), GenericUDFOPEqualNS.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPEqualOrLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPGreaterThan.class.getAnnotation(Description.class).name(), GenericUDFOPLessThan.class.getAnnotation(Description.class).name(), GenericUDFOPNotEqual.class.getAnnotation(Description.class).name());
    private static final String IN_UDF = GenericUDFIn.class.getAnnotation(Description.class).name();
    private static final String BETWEEN_UDF = GenericUDFBetween.class.getAnnotation(Description.class).name();

    private HivePreFilteringRule() {
        super(HivePreFilteringRule.operand(Filter.class, HivePreFilteringRule.operand(RelNode.class, HivePreFilteringRule.any()), new RelOptRuleOperand[0]));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Object filterChild = call.rel(1);
        if (filterChild instanceof TableScan) {
            return;
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode condition = RexUtil.pullFactors(rexBuilder, filter.getCondition());
        List<Object> commonOperands = new ArrayList();
        switch (condition.getKind()) {
            case AND: {
                ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)condition).getOperands());
                for (RexNode operand : operands) {
                    if (operand.getKind() != SqlKind.OR) continue;
                    commonOperands.addAll(HivePreFilteringRule.extractCommonOperands(rexBuilder, operand));
                }
                break;
            }
            case OR: {
                commonOperands = HivePreFilteringRule.extractCommonOperands(rexBuilder, condition);
                break;
            }
            default: {
                return;
            }
        }
        if (commonOperands.isEmpty()) {
            return;
        }
        RelOptPredicateList predicates = RelMetadataQuery.getPulledUpPredicates(filter);
        ArrayList<RexNode> newConjuncts = new ArrayList<RexNode>();
        for (RexNode rexNode : commonOperands) {
            boolean found = false;
            for (RexNode conjunct : predicates.pulledUpPredicates) {
                if (!rexNode.toString().equals(conjunct.toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            newConjuncts.add(rexNode);
        }
        if (newConjuncts.isEmpty()) {
            return;
        }
        RexNode newCondition = RexUtil.pullFactors(rexBuilder, RexUtil.composeConjunction(rexBuilder, newConjuncts, false));
        RelNode relNode = this.filterFactory.createFilter((RelNode)filterChild, newCondition);
        RelNode newTopFilter = this.filterFactory.createFilter(relNode, condition);
        call.transformTo(newTopFilter);
    }

    private static List<RexNode> extractCommonOperands(RexBuilder rexBuilder, RexNode condition) {
        assert (condition.getKind() == SqlKind.OR);
        LinkedHashMultimap<String, RexCall> reductionCondition = LinkedHashMultimap.create();
        ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)condition).getOperands());
        for (RexNode operand : operands) {
            RexNode operandCNF = RexUtil.toCnf(rexBuilder, operand);
            List<RexNode> conjunctions = RelOptUtil.conjunctions(operandCNF);
            boolean addedToReductionCondition = false;
            for (RexNode conjunction : conjunctions) {
                if (!(conjunction instanceof RexCall)) continue;
                RexCall conjCall = (RexCall)conjunction;
                if (COMPARISON_UDFS.contains(conjCall.getOperator().getName())) {
                    if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                        reductionCondition.put(((RexNode)conjCall.operands.get(0)).toString(), conjCall);
                        addedToReductionCondition = true;
                        continue;
                    }
                    if (!(conjCall.operands.get(1) instanceof RexInputRef) || !(conjCall.operands.get(0) instanceof RexLiteral)) continue;
                    reductionCondition.put(((RexNode)conjCall.operands.get(1)).toString(), conjCall);
                    addedToReductionCondition = true;
                    continue;
                }
                if (conjCall.getOperator().getName().equals(IN_UDF)) {
                    reductionCondition.put(((RexNode)conjCall.operands.get(0)).toString(), conjCall);
                    addedToReductionCondition = true;
                    continue;
                }
                if (!conjCall.getOperator().getName().equals(BETWEEN_UDF)) continue;
                reductionCondition.put(((RexNode)conjCall.operands.get(1)).toString(), conjCall);
                addedToReductionCondition = true;
            }
            if (addedToReductionCondition) continue;
            return new ArrayList<RexNode>();
        }
        ArrayList<RexNode> commonOperands = new ArrayList<RexNode>();
        for (Map.Entry pair : reductionCondition.asMap().entrySet()) {
            if (pair.getValue().size() != operands.size()) continue;
            commonOperands.add(RexUtil.composeDisjunction(rexBuilder, pair.getValue(), false));
        }
        return commonOperands;
    }
}

