/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.PartitionPrune;

public class HivePartitionPruneRule
extends RelOptRule {
    HiveConf conf;

    public HivePartitionPruneRule(HiveConf conf) {
        super(HivePartitionPruneRule.operand(HiveFilter.class, HivePartitionPruneRule.operand(HiveTableScan.class, HivePartitionPruneRule.none()), new RelOptRuleOperand[0]));
        this.conf = conf;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        HiveTableScan tScan = (HiveTableScan)call.rel(1);
        this.perform(call, filter, tScan);
    }

    protected void perform(RelOptRuleCall call, Filter filter, HiveTableScan tScan) {
        RelOptHiveTable hiveTable = (RelOptHiveTable)tScan.getTable();
        RexNode predicate = filter.getCondition();
        Pair<RexNode, RexNode> predicates = PartitionPrune.extractPartitionPredicates(filter.getCluster(), hiveTable, predicate);
        RexNode partColExpr = (RexNode)predicates.left;
        hiveTable.computePartitionList(this.conf, partColExpr);
    }
}

