/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.rules.MultiJoin;
import hive.org.apache.calcite.rex.RexNode;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;

public class HiveInsertExchange4JoinRule
extends RelOptRule {
    protected static final transient Log LOG = LogFactory.getLog(HiveInsertExchange4JoinRule.class);
    public static final HiveInsertExchange4JoinRule EXCHANGE_BELOW_MULTIJOIN = new HiveInsertExchange4JoinRule(MultiJoin.class);
    public static final HiveInsertExchange4JoinRule EXCHANGE_BELOW_JOIN = new HiveInsertExchange4JoinRule(Join.class);

    public HiveInsertExchange4JoinRule(Class<? extends RelNode> clazz) {
        super(RelOptRule.operand(clazz, HiveInsertExchange4JoinRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newOp;
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        if (call.rel(0) instanceof MultiJoin) {
            MultiJoin multiJoin = (MultiJoin)call.rel(0);
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(multiJoin);
        } else if (call.rel(0) instanceof Join) {
            Join join = (Join)call.rel(0);
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        } else {
            return;
        }
        for (RelNode child : call.rel(0).getInputs()) {
            if (!(((HepRelVertex)child).getCurrentRel() instanceof Exchange)) continue;
            return;
        }
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (int i = 0; i < call.rel(0).getInputs().size(); ++i) {
            ArrayList<Integer> joinKeyPositions = new ArrayList<Integer>();
            ImmutableList.Builder keyListBuilder = new ImmutableList.Builder();
            ImmutableList.Builder collationListBuilder = new ImmutableList.Builder();
            for (int j = 0; j < joinPredInfo.getEquiJoinPredicateElements().size(); ++j) {
                HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredInfo = joinPredInfo.getEquiJoinPredicateElements().get(j);
                for (int pos : joinLeafPredInfo.getProjsJoinKeysInChildSchema(i)) {
                    if (joinKeyPositions.contains(pos)) continue;
                    joinKeyPositions.add(pos);
                    collationListBuilder.add(new RelFieldCollation(pos));
                    keyListBuilder.add(joinLeafPredInfo.getJoinKeyExprs(i).get(0));
                }
            }
            HiveSortExchange exchange = HiveSortExchange.create(call.rel(0).getInput(i), new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, joinKeyPositions), new HiveRelCollation((ImmutableList<RelFieldCollation>)collationListBuilder.build()), (ImmutableList<RexNode>)keyListBuilder.build());
            newInputs.add(exchange);
        }
        if (call.rel(0) instanceof MultiJoin) {
            MultiJoin multiJoin = (MultiJoin)call.rel(0);
            newOp = multiJoin.copy(multiJoin.getTraitSet(), newInputs);
        } else if (call.rel(0) instanceof Join) {
            Join join = (Join)call.rel(0);
            newOp = join.copy(join.getTraitSet(), join.getCondition(), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getJoinType(), join.isSemiJoinDone());
        } else {
            return;
        }
        call.getPlanner().onCopy((RelNode)call.rel(0), newOp);
        call.transformTo(newOp);
    }
}

