/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributionTraitDef;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.SortExchange;
import hive.org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class HiveSortExchange
extends SortExchange {
    private ImmutableList<RexNode> joinKeys;
    private ExprNodeDesc[] joinExpressions;

    private HiveSortExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> joinKeys) {
        super(cluster, traitSet, input, distribution, collation);
        this.joinKeys = ((ImmutableList.Builder)new ImmutableList.Builder().addAll(joinKeys)).build();
    }

    public static HiveSortExchange create(RelNode input, RelDistribution distribution, RelCollation collation, ImmutableList<RexNode> joinKeys) {
        RelOptCluster cluster = input.getCluster();
        distribution = RelDistributionTraitDef.INSTANCE.canonize(distribution);
        collation = RelCollationTraitDef.INSTANCE.canonize(collation);
        RelTraitSet traitSet = RelTraitSet.createEmpty().plus(distribution).plus(collation);
        return new HiveSortExchange(cluster, traitSet, input, distribution, collation, joinKeys);
    }

    @Override
    public SortExchange copy(RelTraitSet traitSet, RelNode newInput, RelDistribution newDistribution, RelCollation newCollation) {
        return new HiveSortExchange(this.getCluster(), traitSet, newInput, newDistribution, newCollation, this.joinKeys);
    }

    public ImmutableList<RexNode> getJoinKeys() {
        return this.joinKeys;
    }

    public void setJoinKeys(ImmutableList<RexNode> joinKeys) {
        this.joinKeys = joinKeys;
    }

    public ExprNodeDesc[] getJoinExpressions() {
        return this.joinExpressions;
    }

    public void setJoinExpressions(ExprNodeDesc[] joinExpressions) {
        this.joinExpressions = joinExpressions;
    }
}

