/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.IntList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveAggregate
extends Aggregate
implements HiveRelNode {
    public static final HiveAggRelFactory HIVE_AGGR_REL_FACTORY = new HiveAggRelFactory();

    public HiveAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, indicator, groupSet, groupSets, aggCalls);
    }

    @Override
    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new HiveAggregate(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return RelMetadataQuery.getNonCumulativeCost(this);
    }

    @Override
    public double getRows() {
        return RelMetadataQuery.getDistinctRowCount(this, this.groupSet, this.getCluster().getRexBuilder().makeLiteral(true));
    }

    public boolean isBucketedInput() {
        return RelMetadataQuery.distribution(this.getInput()).getKeys().containsAll(this.groupSet.asList());
    }

    @Override
    protected RelDataType deriveRowType() {
        return HiveAggregate.deriveRowType(this.getCluster().getTypeFactory(), this.getInput().getRowType(), this.indicator, this.groupSet, this.groupSets, this.aggCalls);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        int groupKey;
        IntList groupList = groupSet.toList();
        assert (groupList.size() == groupSet.cardinality());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        List<RelDataTypeField> fieldList = inputRowType.getFieldList();
        HashSet<String> containedNames = Sets.newHashSet();
        Iterator i$ = groupList.iterator();
        while (i$.hasNext()) {
            groupKey = (Integer)i$.next();
            containedNames.add(fieldList.get(groupKey).getName());
            builder.add(fieldList.get(groupKey));
        }
        if (indicator) {
            i$ = groupList.iterator();
            while (i$.hasNext()) {
                groupKey = (Integer)i$.next();
                RelDataType booleanType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
                String name = "i$" + fieldList.get(groupKey).getName();
                int i = 0;
                while (containedNames.contains(name)) {
                    name = name + "_" + i++;
                }
                containedNames.add(name);
                builder.add(name, booleanType);
            }
        }
        for (Ord aggCall : Ord.zip(aggCalls)) {
            String name = ((AggregateCall)aggCall.e).name != null ? ((AggregateCall)aggCall.e).name : "$f" + (groupList.size() + aggCall.i);
            int i = 0;
            while (containedNames.contains(name)) {
                name = name + "_" + i++;
            }
            containedNames.add(name);
            builder.add(name, ((AggregateCall)aggCall.e).type);
        }
        return builder.build();
    }

    private static class HiveAggRelFactory
    implements RelFactories.AggregateFactory {
        private HiveAggRelFactory() {
        }

        @Override
        public RelNode createAggregate(RelNode child, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            try {
                return new HiveAggregate(child.getCluster(), child.getTraitSet(), child, indicator, groupSet, groupSets, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

