/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableMap;
import hive.com.google.common.collect.ImmutableSet;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.rules.MultiJoin;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexCorrelVariable;
import hive.org.apache.calcite.rex.RexDynamicParam;
import hive.org.apache.calcite.rex.RexFieldAccess;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexLocalRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexOver;
import hive.org.apache.calcite.rex.RexRangeRef;
import hive.org.apache.calcite.rex.RexVisitor;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.validate.SqlValidatorUtil;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class HiveCalciteUtil {
    public static List<Integer> getVirtualCols(List<? extends RexNode> exps) {
        ArrayList<Integer> vCols = new ArrayList<Integer>();
        for (int i = 0; i < exps.size(); ++i) {
            if (exps.get(i) instanceof RexInputRef) continue;
            vCols.add(i);
        }
        return vCols;
    }

    public static boolean validateASTForUnsupportedTokens(ASTNode ast) {
        String[] tokens;
        String astTree = ast.toStringTree();
        for (String token : tokens = new String[]{"TOK_CHARSETLITERAL", "TOK_TABLESPLITSAMPLE"}) {
            if (!astTree.contains(token)) continue;
            return false;
        }
        return true;
    }

    public static List<RexNode> getProjsFromBelowAsInputRef(final RelNode rel) {
        List<RexNode> projectList = Lists.transform(rel.getRowType().getFieldList(), new Function<RelDataTypeField, RexNode>(){

            @Override
            public RexNode apply(RelDataTypeField field) {
                return rel.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
            }
        });
        return projectList;
    }

    public static List<Integer> translateBitSetToProjIndx(ImmutableBitSet projBitSet) {
        ArrayList<Integer> projIndxLst = new ArrayList<Integer>();
        for (int i = 0; i < projBitSet.length(); ++i) {
            if (!projBitSet.get(i)) continue;
            projIndxLst.add(i);
        }
        return projIndxLst;
    }

    public static RexNode projectNonColumnEquiConditions(RelFactories.ProjectFactory factory, RelNode[] inputRels, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, int systemColCount, List<Integer> leftKeys, List<Integer> rightKeys) {
        RelDataTypeField field;
        int i;
        RelNode leftRel = inputRels[0];
        RelNode rightRel = inputRels[1];
        RexBuilder rexBuilder = leftRel.getCluster().getRexBuilder();
        RexNode outJoinCond = null;
        int origLeftInputSize = leftRel.getRowType().getFieldCount();
        int origRightInputSize = rightRel.getRowType().getFieldCount();
        ArrayList<RexNode> newLeftFields = new ArrayList<RexNode>();
        ArrayList<String> newLeftFieldNames = new ArrayList<String>();
        ArrayList<RexNode> newRightFields = new ArrayList<RexNode>();
        ArrayList<String> newRightFieldNames = new ArrayList<String>();
        int leftKeyCount = leftJoinKeys.size();
        for (i = 0; i < origLeftInputSize; ++i) {
            field = leftRel.getRowType().getFieldList().get(i);
            newLeftFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newLeftFieldNames.add(field.getName());
        }
        for (i = 0; i < origRightInputSize; ++i) {
            field = rightRel.getRowType().getFieldList().get(i);
            newRightFields.add(rexBuilder.makeInputRef(field.getType(), i));
            newRightFieldNames.add(field.getName());
        }
        int newKeyCount = 0;
        ArrayList<Pair<Integer, Integer>> origColEqConds = new ArrayList<Pair<Integer, Integer>>();
        for (i = 0; i < leftKeyCount; ++i) {
            RexNode leftKey = leftJoinKeys.get(i);
            RexNode rightKey = rightJoinKeys.get(i);
            if (leftKey instanceof RexInputRef && rightKey instanceof RexInputRef) {
                origColEqConds.add(Pair.of(((RexInputRef)leftKey).getIndex(), ((RexInputRef)rightKey).getIndex()));
                continue;
            }
            newLeftFields.add(leftKey);
            newLeftFieldNames.add(null);
            newRightFields.add(rightKey);
            newRightFieldNames.add(null);
            ++newKeyCount;
        }
        for (i = 0; i < origColEqConds.size(); ++i) {
            Pair p = (Pair)origColEqConds.get(i);
            RexNode leftKey = leftJoinKeys.get(i);
            RexNode rightKey = rightJoinKeys.get(i);
            leftKeys.add((Integer)p.left);
            rightKeys.add((Integer)p.right);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(leftKey.getType(), systemColCount + (Integer)p.left), rexBuilder.makeInputRef(rightKey.getType(), systemColCount + origLeftInputSize + newKeyCount + (Integer)p.right));
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, outJoinCond, cond);
        }
        if (newKeyCount == 0) {
            return outJoinCond;
        }
        int newLeftOffset = systemColCount + origLeftInputSize;
        int newRightOffset = systemColCount + origLeftInputSize + origRightInputSize + newKeyCount;
        for (i = 0; i < newKeyCount; ++i) {
            leftKeys.add(origLeftInputSize + i);
            rightKeys.add(origRightInputSize + i);
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(((RexNode)newLeftFields.get(i)).getType(), newLeftOffset + i), rexBuilder.makeInputRef(((RexNode)newLeftFields.get(i)).getType(), newRightOffset + i));
            outJoinCond = outJoinCond == null ? cond : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, outJoinCond, cond);
        }
        if (newKeyCount > 0) {
            leftRel = factory.createProject(leftRel, newLeftFields, SqlValidatorUtil.uniquify(newLeftFieldNames));
            rightRel = factory.createProject(rightRel, newRightFields, SqlValidatorUtil.uniquify(newRightFieldNames));
        }
        inputRels[0] = leftRel;
        inputRels[1] = rightRel;
        return outJoinCond;
    }

    public static boolean limitRelNode(RelNode rel) {
        return rel instanceof Sort && ((Sort)rel).getCollation().getFieldCollations().isEmpty();
    }

    public static boolean orderRelNode(RelNode rel) {
        return rel instanceof Sort && !((Sort)rel).getCollation().getFieldCollations().isEmpty();
    }

    public static Pair<RelNode, RelNode> getTopLevelSelect(RelNode rootRel) {
        RelNode parentOforiginalProjRel = rootRel;
        HiveProject originalProjRel = null;
        for (RelNode tmpRel = rootRel; tmpRel != null; tmpRel = tmpRel.getInput(0)) {
            if (tmpRel instanceof HiveProject) {
                originalProjRel = (HiveProject)tmpRel;
                break;
            }
            parentOforiginalProjRel = tmpRel;
        }
        return new Pair<RelNode, Object>(parentOforiginalProjRel, originalProjRel);
    }

    public static boolean isDeterministic(RexNode expr) {
        boolean deterministic = true;
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitCall(RexCall call) {
                if (!call.getOperator().isDeterministic()) {
                    throw new Util.FoundOne(call);
                }
                return (Void)super.visitCall(call);
            }
        };
        try {
            expr.accept(visitor);
        }
        catch (Util.FoundOne e) {
            deterministic = false;
        }
        return deterministic;
    }

    public static <T> ImmutableMap<Integer, T> getColInfoMap(List<T> hiveCols, int startIndx) {
        ImmutableMap.Builder<Integer, T> bldr = ImmutableMap.builder();
        int indx = startIndx;
        for (T ci : hiveCols) {
            bldr.put(indx, ci);
            ++indx;
        }
        return bldr.build();
    }

    public static ImmutableSet<Integer> shiftVColsSet(Set<Integer> hiveVCols, int shift) {
        ImmutableSet.Builder bldr = ImmutableSet.builder();
        for (Integer pos : hiveVCols) {
            bldr.add((Object)(shift + pos));
        }
        return bldr.build();
    }

    public static ImmutableMap<Integer, VirtualColumn> getVColsMap(List<VirtualColumn> hiveVCols, int startIndx) {
        ImmutableMap.Builder<Integer, VirtualColumn> bldr = ImmutableMap.builder();
        int indx = startIndx;
        for (VirtualColumn vc : hiveVCols) {
            bldr.put(indx, vc);
            ++indx;
        }
        return bldr.build();
    }

    public static ImmutableMap<String, Integer> getColNameIndxMap(List<FieldSchema> tableFields) {
        ImmutableMap.Builder<String, Integer> bldr = ImmutableMap.builder();
        int indx = 0;
        for (FieldSchema fs : tableFields) {
            bldr.put(fs.getName(), indx);
            ++indx;
        }
        return bldr.build();
    }

    public static ImmutableMap<String, Integer> getRowColNameIndxMap(List<RelDataTypeField> rowFields) {
        ImmutableMap.Builder<String, Integer> bldr = ImmutableMap.builder();
        int indx = 0;
        for (RelDataTypeField rdt : rowFields) {
            bldr.put(rdt.getName(), indx);
            ++indx;
        }
        return bldr.build();
    }

    public static ImmutableList<RexNode> getInputRef(List<Integer> inputRefs, RelNode inputRel) {
        ImmutableList.Builder bldr = ImmutableList.builder();
        for (int i : inputRefs) {
            bldr.add(new RexInputRef(i, inputRel.getRowType().getFieldList().get(i).getType()));
        }
        return bldr.build();
    }

    public static ExprNodeDesc getExprNode(Integer inputRefIndx, RelNode inputRel, ExprNodeConverter exprConv) {
        ExprNodeDesc exprNode = null;
        RexInputRef rexInputRef = new RexInputRef(inputRefIndx, inputRel.getRowType().getFieldList().get(inputRefIndx).getType());
        exprNode = ((RexNode)rexInputRef).accept(exprConv);
        return exprNode;
    }

    public static List<ExprNodeDesc> getExprNodes(List<Integer> inputRefs, RelNode inputRel, String inputTabAlias) {
        ArrayList<ExprNodeDesc> exprNodes = new ArrayList<ExprNodeDesc>();
        ImmutableList<RexNode> rexInputRefs = HiveCalciteUtil.getInputRef(inputRefs, inputRel);
        ExprNodeConverter exprConv = new ExprNodeConverter(inputTabAlias, inputRel.getRowType(), new HashSet<Integer>(), inputRel.getCluster().getTypeFactory());
        for (RexNode iRef : rexInputRefs) {
            exprNodes.add(iRef.accept(exprConv));
        }
        return exprNodes;
    }

    public static List<String> getFieldNames(List<Integer> inputRefs, RelNode inputRel) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        List<String> schemaNames = inputRel.getRowType().getFieldNames();
        for (Integer iRef : inputRefs) {
            fieldNames.add(schemaNames.get(iRef));
        }
        return fieldNames;
    }

    public static Set<Integer> getInputRefs(RexNode expr) {
        InputRefsCollector irefColl = new InputRefsCollector(true);
        return irefColl.getInputRefSet();
    }

    private static class InputRefsCollector
    extends RexVisitorImpl<Void> {
        private Set<Integer> inputRefSet = new HashSet<Integer>();

        private InputRefsCollector(boolean deep) {
            super(deep);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.inputRefSet.add(inputRef.getIndex());
            return null;
        }

        public Set<Integer> getInputRefSet() {
            return this.inputRefSet;
        }
    }

    public static class ConstantFinder
    implements RexVisitor<Boolean> {
        @Override
        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            return false;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            throw new RuntimeException("Not expected to be called.");
        }

        @Override
        public Boolean visitOver(RexOver over) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        @Override
        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return false;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            return call.getOperator().isDeterministic() && RexVisitorImpl.visitArrayAnd(this, call.getOperands());
        }

        @Override
        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return fieldAccess.getReferenceExpr().accept(this);
        }
    }

    public static class JoinLeafPredicateInfo {
        private final SqlKind comparisonType;
        private final ImmutableList<ImmutableList<RexNode>> joinKeyExprs;
        private final ImmutableList<ImmutableSet<Integer>> projsJoinKeysInChildSchema;
        private final ImmutableList<ImmutableSet<Integer>> projsJoinKeysInJoinSchema;

        public JoinLeafPredicateInfo(SqlKind comparisonType, List<List<RexNode>> joinKeyExprs, List<Set<Integer>> projsJoinKeysInChildSchema, List<Set<Integer>> projsJoinKeysInJoinSchema) {
            this.comparisonType = comparisonType;
            ImmutableList.Builder joinKeyExprsBuilder = ImmutableList.builder();
            for (int i = 0; i < joinKeyExprs.size(); ++i) {
                joinKeyExprsBuilder.add(ImmutableList.copyOf((Collection)joinKeyExprs.get(i)));
            }
            this.joinKeyExprs = joinKeyExprsBuilder.build();
            ImmutableList.Builder projsJoinKeysInChildSchemaBuilder = ImmutableList.builder();
            for (int i = 0; i < joinKeyExprs.size(); ++i) {
                projsJoinKeysInChildSchemaBuilder.add(ImmutableSet.copyOf((Collection)projsJoinKeysInChildSchema.get(i)));
            }
            this.projsJoinKeysInChildSchema = projsJoinKeysInChildSchemaBuilder.build();
            ImmutableList.Builder projsJoinKeysInJoinSchemaBuilder = ImmutableList.builder();
            for (int i = 0; i < joinKeyExprs.size(); ++i) {
                projsJoinKeysInJoinSchemaBuilder.add(ImmutableSet.copyOf((Collection)projsJoinKeysInJoinSchema.get(i)));
            }
            this.projsJoinKeysInJoinSchema = projsJoinKeysInJoinSchemaBuilder.build();
        }

        public List<RexNode> getJoinKeyExprs(int input) {
            return (List)this.joinKeyExprs.get(input);
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInChildSchema() {
            assert (this.projsJoinKeysInChildSchema.size() == 2);
            return (Set)this.projsJoinKeysInChildSchema.get(0);
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInChildSchema() {
            assert (this.projsJoinKeysInChildSchema.size() == 2);
            return (Set)this.projsJoinKeysInChildSchema.get(1);
        }

        public Set<Integer> getProjsJoinKeysInChildSchema(int input) {
            return (Set)this.projsJoinKeysInChildSchema.get(input);
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInJoinSchema() {
            assert (this.projsJoinKeysInJoinSchema.size() == 2);
            return (Set)this.projsJoinKeysInJoinSchema.get(0);
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInJoinSchema() {
            assert (this.projsJoinKeysInJoinSchema.size() == 2);
            return (Set)this.projsJoinKeysInJoinSchema.get(1);
        }

        public Set<Integer> getProjsJoinKeysInJoinSchema(int input) {
            return (Set)this.projsJoinKeysInJoinSchema.get(input);
        }

        private static JoinLeafPredicateInfo constructJoinLeafPredicateInfo(List<RelNode> inputs, List<RelDataTypeField> systemFieldList, RexNode pe) {
            JoinLeafPredicateInfo jlpi = null;
            ArrayList<Integer> filterNulls = new ArrayList<Integer>();
            ArrayList<List<RexNode>> joinKeyExprs = new ArrayList<List<RexNode>>();
            for (int i = 0; i < inputs.size(); ++i) {
                joinKeyExprs.add(new ArrayList());
            }
            HiveRelOptUtil.splitJoinCondition(systemFieldList, inputs, pe, joinKeyExprs, filterNulls, null);
            ArrayList<Set<Integer>> projsJoinKeysInChildSchema = new ArrayList<Set<Integer>>();
            for (int i = 0; i < inputs.size(); ++i) {
                ImmutableSet.Builder projsFromInputJoinKeysInChildSchema = ImmutableSet.builder();
                RelOptUtil.InputReferencedVisitor irvLeft = new RelOptUtil.InputReferencedVisitor();
                irvLeft.apply((List)joinKeyExprs.get(i));
                projsFromInputJoinKeysInChildSchema.addAll(irvLeft.inputPosReferenced);
                projsJoinKeysInChildSchema.add((Set<Integer>)((Object)projsFromInputJoinKeysInChildSchema.build()));
            }
            ArrayList<Set<Integer>> projsJoinKeysInJoinSchema = new ArrayList<Set<Integer>>();
            projsJoinKeysInJoinSchema.add((Set<Integer>)projsJoinKeysInChildSchema.get(0));
            for (int i = 1; i < inputs.size(); ++i) {
                int offSet = inputs.get(i - 1).getRowType().getFieldCount();
                ImmutableSet.Builder projsFromInputJoinKeysInJoinSchema = ImmutableSet.builder();
                for (Integer indx : (Set)projsJoinKeysInChildSchema.get(i)) {
                    projsFromInputJoinKeysInJoinSchema.add((Object)(indx + offSet));
                }
                projsJoinKeysInJoinSchema.add((Set<Integer>)((Object)projsFromInputJoinKeysInJoinSchema.build()));
            }
            jlpi = new JoinLeafPredicateInfo(pe.getKind(), joinKeyExprs, projsJoinKeysInChildSchema, projsJoinKeysInJoinSchema);
            return jlpi;
        }
    }

    public static class JoinPredicateInfo {
        private final ImmutableList<JoinLeafPredicateInfo> nonEquiJoinPredicateElements;
        private final ImmutableList<JoinLeafPredicateInfo> equiJoinPredicateElements;
        private final ImmutableList<Set<Integer>> projsJoinKeysInChildSchema;
        private final ImmutableList<Set<Integer>> projsJoinKeysInJoinSchema;
        private final ImmutableMap<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo;

        public JoinPredicateInfo(List<JoinLeafPredicateInfo> nonEquiJoinPredicateElements, List<JoinLeafPredicateInfo> equiJoinPredicateElements, List<Set<Integer>> projsJoinKeysInChildSchema, List<Set<Integer>> projsJoinKeysInJoinSchema, Map<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo) {
            this.nonEquiJoinPredicateElements = ImmutableList.copyOf(nonEquiJoinPredicateElements);
            this.equiJoinPredicateElements = ImmutableList.copyOf(equiJoinPredicateElements);
            this.projsJoinKeysInChildSchema = ImmutableList.copyOf(projsJoinKeysInChildSchema);
            this.projsJoinKeysInJoinSchema = ImmutableList.copyOf(projsJoinKeysInJoinSchema);
            this.mapOfProjIndxInJoinSchemaToLeafPInfo = ImmutableMap.copyOf(mapOfProjIndxInJoinSchemaToLeafPInfo);
        }

        public List<JoinLeafPredicateInfo> getNonEquiJoinPredicateElements() {
            return this.nonEquiJoinPredicateElements;
        }

        public List<JoinLeafPredicateInfo> getEquiJoinPredicateElements() {
            return this.equiJoinPredicateElements;
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInChildSchema() {
            assert (this.projsJoinKeysInChildSchema.size() == 2);
            return (Set)this.projsJoinKeysInChildSchema.get(0);
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInChildSchema() {
            assert (this.projsJoinKeysInChildSchema.size() == 2);
            return (Set)this.projsJoinKeysInChildSchema.get(1);
        }

        public Set<Integer> getProjsJoinKeysInChildSchema(int i) {
            return (Set)this.projsJoinKeysInChildSchema.get(i);
        }

        public Set<Integer> getProjsFromLeftPartOfJoinKeysInJoinSchema() {
            assert (this.projsJoinKeysInJoinSchema.size() == 2);
            return (Set)this.projsJoinKeysInJoinSchema.get(0);
        }

        public Set<Integer> getProjsFromRightPartOfJoinKeysInJoinSchema() {
            assert (this.projsJoinKeysInJoinSchema.size() == 2);
            return (Set)this.projsJoinKeysInJoinSchema.get(1);
        }

        public Set<Integer> getProjsJoinKeysInJoinSchema(int i) {
            return (Set)this.projsJoinKeysInJoinSchema.get(i);
        }

        public Map<Integer, ImmutableList<JoinLeafPredicateInfo>> getMapOfProjIndxToLeafPInfo() {
            return this.mapOfProjIndxInJoinSchemaToLeafPInfo;
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(Join j) {
            return JoinPredicateInfo.constructJoinPredicateInfo(j, j.getCondition());
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(MultiJoin mj) {
            return JoinPredicateInfo.constructJoinPredicateInfo(mj, mj.getJoinFilter());
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(Join j, RexNode predicate) {
            return JoinPredicateInfo.constructJoinPredicateInfo(j.getInputs(), j.getSystemFieldList(), predicate);
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(MultiJoin mj, RexNode predicate) {
            ImmutableList<RelDataTypeField> systemFieldList = ImmutableList.of();
            return JoinPredicateInfo.constructJoinPredicateInfo(mj.getInputs(), systemFieldList, predicate);
        }

        public static JoinPredicateInfo constructJoinPredicateInfo(List<RelNode> inputs, List<RelDataTypeField> systemFieldList, RexNode predicate) {
            JoinPredicateInfo jpi = null;
            JoinLeafPredicateInfo jlpi = null;
            ArrayList<JoinLeafPredicateInfo> equiLPIList = new ArrayList<JoinLeafPredicateInfo>();
            ArrayList<JoinLeafPredicateInfo> nonEquiLPIList = new ArrayList<JoinLeafPredicateInfo>();
            ArrayList<Set<Integer>> projsJoinKeys = new ArrayList<Set<Integer>>();
            for (int i = 0; i < inputs.size(); ++i) {
                HashSet projsJoinKeysInput = Sets.newHashSet();
                projsJoinKeys.add(projsJoinKeysInput);
            }
            ArrayList<Set<Integer>> projsJoinKeysInJoinSchema = new ArrayList<Set<Integer>>();
            for (int i = 0; i < inputs.size(); ++i) {
                HashSet projsJoinKeysInJoinSchemaInput = Sets.newHashSet();
                projsJoinKeysInJoinSchema.add(projsJoinKeysInJoinSchemaInput);
            }
            HashMap<Integer, ArrayList<JoinLeafPredicateInfo>> tmpMapOfProjIndxInJoinSchemaToLeafPInfo = new HashMap<Integer, ArrayList<JoinLeafPredicateInfo>>();
            HashMap<Integer, ImmutableList<JoinLeafPredicateInfo>> mapOfProjIndxInJoinSchemaToLeafPInfo = new HashMap<Integer, ImmutableList<JoinLeafPredicateInfo>>();
            ArrayList<JoinLeafPredicateInfo> tmpJLPILst = null;
            List<RexNode> conjuctiveElements = RelOptUtil.conjunctions(predicate);
            for (RexNode rexNode : conjuctiveElements) {
                jlpi = JoinLeafPredicateInfo.constructJoinLeafPredicateInfo(inputs, systemFieldList, rexNode);
                if (jlpi.comparisonType.equals((Object)SqlKind.EQUALS)) {
                    equiLPIList.add(jlpi);
                } else {
                    nonEquiLPIList.add(jlpi);
                }
                for (int i = 0; i < inputs.size(); ++i) {
                    ((Set)projsJoinKeys.get(i)).addAll(jlpi.getProjsJoinKeysInChildSchema(i));
                    ((Set)projsJoinKeysInJoinSchema.get(i)).addAll(jlpi.getProjsJoinKeysInJoinSchema(i));
                    for (Integer projIndx : jlpi.getProjsJoinKeysInJoinSchema(i)) {
                        tmpJLPILst = (ArrayList<JoinLeafPredicateInfo>)tmpMapOfProjIndxInJoinSchemaToLeafPInfo.get(projIndx);
                        if (tmpJLPILst == null) {
                            tmpJLPILst = new ArrayList<JoinLeafPredicateInfo>();
                        }
                        tmpJLPILst.add(jlpi);
                        tmpMapOfProjIndxInJoinSchemaToLeafPInfo.put(projIndx, tmpJLPILst);
                    }
                }
            }
            for (Map.Entry entry : tmpMapOfProjIndxInJoinSchemaToLeafPInfo.entrySet()) {
                mapOfProjIndxInJoinSchemaToLeafPInfo.put((Integer)entry.getKey(), ImmutableList.copyOf((Collection)entry.getValue()));
            }
            jpi = new JoinPredicateInfo(nonEquiLPIList, equiLPIList, projsJoinKeys, projsJoinKeysInJoinSchema, mapOfProjIndxInJoinSchemaToLeafPInfo);
            return jpi;
        }
    }
}

