/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import hive.com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;

public abstract class VectorExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected VectorExpression[] childExpressions = null;
    protected Type[] inputTypes;
    protected String outputType;

    public abstract void evaluate(VectorizedRowBatch var1);

    public abstract int getOutputColumn();

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String type) {
        this.outputType = type;
    }

    public void setChildExpressions(VectorExpression[] ve) {
        this.childExpressions = ve;
    }

    public VectorExpression[] getChildExpressions() {
        return this.childExpressions;
    }

    public abstract VectorExpressionDescriptor.Descriptor getDescriptor();

    protected final void evaluateChildren(VectorizedRowBatch vrg) {
        if (this.childExpressions != null) {
            for (VectorExpression ve : this.childExpressions) {
                ve.evaluate(vrg);
            }
        }
    }

    public void setInputTypes(Type ... inputTypes) {
        this.inputTypes = inputTypes;
    }

    public Type[] getInputTypes() {
        return this.inputTypes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        b.append(this.getOutputColumn());
        b.append("]");
        if (this.childExpressions != null) {
            b.append("(");
            for (int i = 0; i < this.childExpressions.length; ++i) {
                b.append(this.childExpressions[i].toString());
                if (i >= this.childExpressions.length - 1) continue;
                b.append(" ");
            }
            b.append(")");
        }
        return b.toString();
    }

    public static enum Type {
        STRING,
        CHAR,
        VARCHAR,
        TIMESTAMP,
        DATE,
        LONG,
        DOUBLE,
        DECIMAL,
        INTERVAL_YEAR_MONTH,
        INTERVAL_DAY_TIME,
        OTHER;

        private static Map<String, Type> types;

        public static Type getValue(String name) {
            String nameLower = name.toLowerCase();
            if (types.containsKey(nameLower)) {
                return types.get(nameLower);
            }
            return OTHER;
        }

        static {
            types = ImmutableMap.builder().put("string", STRING).put("char", CHAR).put("varchar", VARCHAR).put("timestamp", TIMESTAMP).put("date", DATE).put("long", LONG).put("double", DOUBLE).put("decimal", DECIMAL).put("interval_year_month", INTERVAL_YEAR_MONTH).put("interval_day_time", INTERVAL_DAY_TIME).build();
        }
    }
}

