/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import hive.com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.JobMetricsListener;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.api.java.JavaFutureAction;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import scala.Option;

public class LocalSparkJobStatus
implements SparkJobStatus {
    private final JavaSparkContext sparkContext;
    private static final Log LOG = LogFactory.getLog((String)LocalSparkJobStatus.class.getName());
    private int jobId;
    private JobMetricsListener jobMetricsListener;
    private SparkCounters sparkCounters;
    private JavaFutureAction<Void> future;
    private Set<Integer> cachedRDDIds;

    public LocalSparkJobStatus(JavaSparkContext sparkContext, int jobId, JobMetricsListener jobMetricsListener, SparkCounters sparkCounters, Set<Integer> cachedRDDIds, JavaFutureAction<Void> future) {
        this.sparkContext = sparkContext;
        this.jobId = jobId;
        this.jobMetricsListener = jobMetricsListener;
        this.sparkCounters = sparkCounters;
        this.cachedRDDIds = cachedRDDIds;
        this.future = future;
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public JobExecutionStatus getState() {
        SparkJobInfo sparkJobInfo = this.getJobInfo();
        if (sparkJobInfo == null && this.future.isDone()) {
            try {
                this.future.get();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to run job " + this.jobId), (Throwable)e);
                return JobExecutionStatus.FAILED;
            }
            return JobExecutionStatus.SUCCEEDED;
        }
        return sparkJobInfo == null ? null : sparkJobInfo.status();
    }

    @Override
    public int[] getStageIds() {
        SparkJobInfo sparkJobInfo = this.getJobInfo();
        return sparkJobInfo == null ? new int[]{} : sparkJobInfo.stageIds();
    }

    @Override
    public Map<String, SparkStageProgress> getSparkStageProgress() {
        HashMap<String, SparkStageProgress> stageProgresses = new HashMap<String, SparkStageProgress>();
        for (int stageId : this.getStageIds()) {
            SparkStageInfo sparkStageInfo = this.getStageInfo(stageId);
            if (sparkStageInfo == null) continue;
            int runningTaskCount = sparkStageInfo.numActiveTasks();
            int completedTaskCount = sparkStageInfo.numCompletedTasks();
            int failedTaskCount = sparkStageInfo.numFailedTasks();
            int totalTaskCount = sparkStageInfo.numTasks();
            SparkStageProgress sparkStageProgress = new SparkStageProgress(totalTaskCount, completedTaskCount, runningTaskCount, failedTaskCount);
            stageProgresses.put(String.valueOf(sparkStageInfo.stageId()) + "_" + sparkStageInfo.currentAttemptId(), sparkStageProgress);
        }
        return stageProgresses;
    }

    @Override
    public SparkCounters getCounter() {
        return this.sparkCounters;
    }

    @Override
    public SparkStatistics getSparkStatistics() {
        SparkStatisticsBuilder sparkStatisticsBuilder = new SparkStatisticsBuilder();
        sparkStatisticsBuilder.add(this.sparkCounters);
        String jobIdentifier = "Spark Job[" + this.jobId + "] Metrics";
        Map<String, List<TaskMetrics>> jobMetric = this.jobMetricsListener.getJobMetric(this.jobId);
        if (jobMetric == null) {
            return null;
        }
        Map<String, Long> flatJobMetric = this.combineJobLevelMetrics(jobMetric);
        for (Map.Entry<String, Long> entry : flatJobMetric.entrySet()) {
            sparkStatisticsBuilder.add(jobIdentifier, entry.getKey(), Long.toString(entry.getValue()));
        }
        return sparkStatisticsBuilder.build();
    }

    @Override
    public void cleanup() {
        this.jobMetricsListener.cleanup(this.jobId);
        if (this.cachedRDDIds != null) {
            for (Integer cachedRDDId : this.cachedRDDIds) {
                this.sparkContext.sc().unpersistRDD(cachedRDDId.intValue(), false);
            }
        }
    }

    private Map<String, Long> combineJobLevelMetrics(Map<String, List<TaskMetrics>> jobMetric) {
        LinkedHashMap<String, Long> results = Maps.newLinkedHashMap();
        long executorDeserializeTime = 0L;
        long executorRunTime = 0L;
        long resultSize = 0L;
        long jvmGCTime = 0L;
        long resultSerializationTime = 0L;
        long memoryBytesSpilled = 0L;
        long diskBytesSpilled = 0L;
        long bytesRead = 0L;
        long remoteBlocksFetched = 0L;
        long localBlocksFetched = 0L;
        long fetchWaitTime = 0L;
        long remoteBytesRead = 0L;
        long shuffleBytesWritten = 0L;
        long shuffleWriteTime = 0L;
        boolean inputMetricExist = false;
        boolean shuffleReadMetricExist = false;
        boolean shuffleWriteMetricExist = false;
        for (List<TaskMetrics> stageMetric : jobMetric.values()) {
            if (stageMetric == null) continue;
            for (TaskMetrics taskMetrics : stageMetric) {
                Option shuffleWriteMetricsOption;
                Option shuffleReadMetricsOption;
                if (taskMetrics == null) continue;
                executorDeserializeTime += taskMetrics.executorDeserializeTime();
                executorRunTime += taskMetrics.executorRunTime();
                resultSize += taskMetrics.resultSize();
                jvmGCTime += taskMetrics.jvmGCTime();
                resultSerializationTime += taskMetrics.resultSerializationTime();
                memoryBytesSpilled += taskMetrics.memoryBytesSpilled();
                diskBytesSpilled += taskMetrics.diskBytesSpilled();
                if (!taskMetrics.inputMetrics().isEmpty()) {
                    inputMetricExist = true;
                    bytesRead += ((InputMetrics)taskMetrics.inputMetrics().get()).bytesRead();
                }
                if (!(shuffleReadMetricsOption = taskMetrics.shuffleReadMetrics()).isEmpty()) {
                    shuffleReadMetricExist = true;
                    remoteBlocksFetched += (long)((ShuffleReadMetrics)shuffleReadMetricsOption.get()).remoteBlocksFetched();
                    localBlocksFetched += (long)((ShuffleReadMetrics)shuffleReadMetricsOption.get()).localBlocksFetched();
                    fetchWaitTime += ((ShuffleReadMetrics)shuffleReadMetricsOption.get()).fetchWaitTime();
                    remoteBytesRead += ((ShuffleReadMetrics)shuffleReadMetricsOption.get()).remoteBytesRead();
                }
                if ((shuffleWriteMetricsOption = taskMetrics.shuffleWriteMetrics()).isEmpty()) continue;
                shuffleWriteMetricExist = true;
                shuffleBytesWritten += ((ShuffleWriteMetrics)shuffleWriteMetricsOption.get()).shuffleBytesWritten();
                shuffleWriteTime += ((ShuffleWriteMetrics)shuffleWriteMetricsOption.get()).shuffleWriteTime();
            }
        }
        results.put("EexcutorDeserializeTime", executorDeserializeTime);
        results.put("ExecutorRunTime", executorRunTime);
        results.put("ResultSize", resultSize);
        results.put("JvmGCTime", jvmGCTime);
        results.put("ResultSerializationTime", resultSerializationTime);
        results.put("MemoryBytesSpilled", memoryBytesSpilled);
        results.put("DiskBytesSpilled", diskBytesSpilled);
        if (inputMetricExist) {
            results.put("BytesRead", bytesRead);
        }
        if (shuffleReadMetricExist) {
            results.put("RemoteBlocksFetched", remoteBlocksFetched);
            results.put("LocalBlocksFetched", localBlocksFetched);
            results.put("TotalBlocksFetched", localBlocksFetched + remoteBlocksFetched);
            results.put("FetchWaitTime", fetchWaitTime);
            results.put("RemoteBytesRead", remoteBytesRead);
        }
        if (shuffleWriteMetricExist) {
            results.put("ShuffleBytesWritten", shuffleBytesWritten);
            results.put("ShuffleWriteTime", shuffleWriteTime);
        }
        return results;
    }

    private SparkJobInfo getJobInfo() {
        return this.sparkContext.statusTracker().getJobInfo(this.jobId);
    }

    private SparkStageInfo getStageInfo(int stageId) {
        return this.sparkContext.statusTracker().getStageInfo(stageId);
    }
}

