/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.hadoop.metadata;

import hive.parquet.Preconditions;
import hive.parquet.hadoop.metadata.Canonicalizer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public final class ColumnPath
implements Iterable<String>,
Serializable {
    private static Canonicalizer<ColumnPath> paths = new Canonicalizer<ColumnPath>(){

        @Override
        protected ColumnPath toCanonical(ColumnPath value) {
            String[] path = new String[value.p.length];
            for (int i = 0; i < value.p.length; ++i) {
                path[i] = value.p[i].intern();
            }
            return new ColumnPath(path);
        }
    };
    private final String[] p;

    public static ColumnPath fromDotString(String path) {
        Preconditions.checkNotNull(path, "path");
        return ColumnPath.get(path.split("\\."));
    }

    public static ColumnPath get(String ... path) {
        return paths.canonicalize(new ColumnPath(path));
    }

    private ColumnPath(String[] path) {
        this.p = path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnPath) {
            return Arrays.equals(this.p, ((ColumnPath)obj).p);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.p);
    }

    public String toDotString() {
        Iterator<String> iter = Arrays.asList(this.p).iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public String toString() {
        return Arrays.toString(this.p);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.p).iterator();
    }

    public int size() {
        return this.p.length;
    }

    public String[] toArray() {
        return this.p;
    }
}

