/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.plain;

import hive.parquet.Log;
import hive.parquet.column.values.ValuesReader;
import hive.parquet.io.ParquetDecodingException;
import hive.parquet.io.api.Binary;
import java.io.IOException;

public class FixedLenByteArrayPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(FixedLenByteArrayPlainValuesReader.class);
    private byte[] in;
    private int offset;
    private int length;

    public FixedLenByteArrayPlainValuesReader(int length) {
        this.length = length;
    }

    @Override
    public Binary readBytes() {
        try {
            int start = this.offset;
            this.offset = start + this.length;
            return Binary.fromByteArray(this.in, start, this.length);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        this.offset += this.length;
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = in;
        this.offset = offset;
    }
}

